/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DBIcon
implements DBPImage {
    private static final Log log = Log.getLog(DBIcon.class);
    public static final DBIcon TREE_ADMIN = new DBIcon("admin", "tree/admin.png");
    public static final DBIcon TREE_DATABASE = new DBIcon("database", "tree/database.png");
    public static final DBIcon TREE_DATABASE_CATEGORY = new DBIcon("database_category", "tree/database_category.png");
    public static final DBIcon TREE_DATABASE_SHARED = new DBIcon("database_shared", "tree/database_shared.png");
    public static final DBIcon TREE_SCHEMA = new DBIcon("schema", "tree/schema.png");
    public static final DBIcon TREE_SCHEMA_SHARED = new DBIcon("schema_shared", "tree/schema_shared.png");
    public static final DBIcon TREE_SCHEMA_SYSTEM = new DBIcon("schema_system", "tree/schema_system.png");
    public static final DBIcon TREE_SCHEMA_UTIL = new DBIcon("schema_util", "tree/schema_util.png");
    public static final DBIcon TREE_TABLE = new DBIcon("table", "tree/table.png");
    public static final DBIcon TREE_TABLE_ALIAS = new DBIcon("table_alias", "tree/table_alias.png");
    public static final DBIcon TREE_TABLE_LINK = new DBIcon("table_link", "tree/table_link.png");
    public static final DBIcon TREE_TABLE_INDEX = new DBIcon("table_index", "tree/table_index.png");
    public static final DBIcon TREE_TABLE_SYSTEM = new DBIcon("table_system", "tree/table_index.png");
    public static final DBIcon TREE_TABLE_EXTERNAL = new DBIcon("table_external", "tree/table_external.png");
    public static final DBIcon TREE_TABLE_SHARED = new DBIcon("table_shared", "tree/table_shared.png");
    public static final DBIcon TREE_VIEW = new DBIcon("view", "tree/view.png");
    public static final DBIcon TREE_VIEW_SHARED = new DBIcon("view_shared", "tree/view_shared.png");
    public static final DBIcon TREE_FUNCTION = new DBIcon("function", "tree/function.png");
    public static final DBIcon TREE_PROCEDURE = new DBIcon("procedure", "tree/procedure.png");
    public static final DBIcon TREE_COLUMNS = new DBIcon("columns", "tree/columns.png");
    public static final DBIcon TREE_COLUMN = new DBIcon("column", "tree/column.png");
    public static final DBIcon TREE_INDEX = new DBIcon("index", "tree/index.png");
    public static final DBIcon TREE_CONSTRAINT = new DBIcon("constraint", "tree/constraint.png");
    public static final DBIcon TREE_UNIQUE_KEY = new DBIcon("unique-key", "tree/unique_constraint.png");
    public static final DBIcon TREE_FOREIGN_KEY = new DBIcon("foreign-key", "tree/foreign_key.png");
    public static final DBIcon TREE_FOREIGN_KEY_COLUMN = new DBIcon("foreign-key-column", "tree/foreign_key_column.png");
    public static final DBIcon TREE_REFERENCE = new DBIcon("reference", "tree/reference.png");
    public static final DBIcon TREE_TRIGGER = new DBIcon("trigger", "tree/trigger.png");
    public static final DBIcon TREE_USER = new DBIcon("user", "tree/user.png");
    public static final DBIcon TREE_USER_GROUP = new DBIcon("user_group", "tree/group.png");
    public static final DBIcon TREE_PERMISSIONS = new DBIcon("permissions", "tree/permissions.png");
    public static final DBIcon TREE_PAGE = new DBIcon("page", "tree/page.png");
    public static final DBIcon TREE_INFO = new DBIcon("info", "tree/info.png");
    public static final DBIcon TREE_SESSIONS = new DBIcon("sessions", "tree/sessions.png");
    public static final DBIcon TREE_LOCKED = new DBIcon("locked", "tree/locked.png");
    public static final DBIcon TREE_UNLOCKED = new DBIcon("unlocked", "tree/unlocked.png");
    public static final DBIcon TREE_PACKAGE = new DBIcon("package", "tree/package.png");
    public static final DBIcon TREE_TASK = new DBIcon("task", "tree/task.png");
    public static final DBIcon TREE_DATA_TYPE = new DBIcon("data_type", "tree/data_type.png");
    public static final DBIcon TREE_SEQUENCE = new DBIcon("sequence", "tree/sequence.png");
    public static final DBIcon TREE_SYNONYM = new DBIcon("synonym", "tree/synonym.png");
    public static final DBIcon TREE_TABLESPACE = new DBIcon("tablespace", "tree/tablespace.png");
    public static final DBIcon TREE_PARTITION = new DBIcon("partition", "tree/partition.png");
    public static final DBIcon TREE_ATTRIBUTE = new DBIcon("attribute", "tree/attribute.png");
    public static final DBIcon TREE_ARGUMENT = new DBIcon("argument", "tree/argument.png");
    public static final DBIcon TREE_JAVA_CLASS = new DBIcon("javaClass", "tree/java_class.png");
    public static final DBIcon TREE_JAVA_INTERFACE = new DBIcon("javaInterface", "tree/java_interface.png");
    public static final DBIcon TREE_LINK = new DBIcon("link", "tree/link.png");
    public static final DBIcon TREE_FILE = new DBIcon("file", "tree/data_file.png");
    public static final DBIcon TREE_CLASS = new DBIcon("class", "tree/class.png");
    public static final DBIcon TREE_ASSOCIATION = new DBIcon("association", "tree/association.png");
    public static final DBIcon TREE_SERVER = new DBIcon("server", "tree/server.png");
    public static final DBIcon TREE_SERVERS = new DBIcon("folder_server", "tree/servers.png");
    public static final DBIcon TREE_RECYCLE_BIN = new DBIcon("recycle_bin", "tree/recycle_bin.png");
    public static final DBIcon TREE_EVENT = new DBIcon("event", "tree/event.png");
    public static final DBIcon TREE_SCHEDULER = new DBIcon("scheduler", "tree/scheduler.png");
    public static final DBIcon TREE_JOB = new DBIcon("job", "tree/job.png");
    public static final DBIcon TREE_JOB_SCHEDULE = new DBIcon("job_schedule", "tree/job_schedule.png");
    public static final DBIcon TREE_FOLDER = new DBIcon("folder", "tree/folder.png");
    public static final DBIcon TREE_FOLDER_LINK = new DBIcon("folder_link", "tree/folder_link.png");
    public static final DBIcon TREE_FOLDER_DATABASE = new DBIcon("folder_database", "tree/folder_database.png");
    public static final DBIcon TREE_FOLDER_SCHEMA = new DBIcon("folder_schema", "tree/folder_schema.png");
    public static final DBIcon TREE_FOLDER_TABLE = new DBIcon("folder_table", "tree/folder_table.png");
    public static final DBIcon TREE_FOLDER_VIEW = new DBIcon("folder_view", "tree/folder_view.png");
    public static final DBIcon TREE_FOLDER_USER = new DBIcon("folder_user", "tree/folder_user.png");
    public static final DBIcon TREE_FOLDER_ADMIN = new DBIcon("folder_admin", "tree/folder_admin.png");
    public static final DBIcon TREE_FOLDER_CONSTRAINT = new DBIcon("constraints", "tree/folder_constraint.png");
    public static final DBIcon TREE_FOLDER_INFO = new DBIcon("folder_info", "tree/folder_info.png");
    public static final DBIcon TREE_KEY = new DBIcon("key", "tree/key.png");
    public static final DBIcon TREE_FOLDER_KEY = new DBIcon("folder_key", "tree/folder_key.png");
    public static final DBIcon PROJECT = new DBIcon("project", "project.png");
    public static final DBIcon TYPE_BOOLEAN = new DBIcon("boolean", "types/boolean.png");
    public static final DBIcon TYPE_NUMBER = new DBIcon("number", "types/number.png");
    public static final DBIcon TYPE_STRING = new DBIcon("string", "types/string.png");
    public static final DBIcon TYPE_DATETIME = new DBIcon("datetime", "types/datetime.png");
    public static final DBIcon TYPE_BINARY = new DBIcon("binary", "types/binary.png");
    public static final DBIcon TYPE_TEXT = new DBIcon("text", "types/text.png");
    public static final DBIcon TYPE_JSON = new DBIcon("json", "types/json.png");
    public static final DBIcon TYPE_XML = new DBIcon("xml", "types/xml.png");
    public static final DBIcon TYPE_LOB = new DBIcon("lob", "types/lob.png");
    public static final DBIcon TYPE_ARRAY = new DBIcon("array", "types/array.png");
    public static final DBIcon TYPE_STRUCT = new DBIcon("struct", "types/struct.png");
    public static final DBIcon TYPE_DOCUMENT = new DBIcon("document", "types/document.png");
    public static final DBIcon TYPE_OBJECT = new DBIcon("object", "types/object.png");
    public static final DBIcon TYPE_IMAGE = new DBIcon("image", "types/image.png");
    public static final DBIcon TYPE_REFERENCE = new DBIcon("reference", "types/reference.png");
    public static final DBIcon TYPE_ROWID = new DBIcon("rowid", "types/rowid.png");
    public static final DBIcon TYPE_ANY = new DBIcon("any", "types/any.png");
    public static final DBIcon TYPE_UUID = new DBIcon("uuid", "types/uuid.png");
    public static final DBIcon TYPE_UNKNOWN = new DBIcon("unknown", "types/unknown.png");
    public static final DBIcon OVER_ADD = new DBIcon("over_add", "over/add_ovr.png");
    public static final DBIcon OVER_SUCCESS = new DBIcon("over_success", "over/success_ovr.png");
    public static final DBIcon OVER_FAILED = new DBIcon("over_failed", "over/failed_ovr.png");
    public static final DBIcon OVER_ERROR = new DBIcon("over_error", "over/error_ovr.png");
    public static final DBIcon OVER_UNKNOWN = new DBIcon("over_condition", "over/conditional_ovr.png");
    public static final DBIcon OVER_LAMP = new DBIcon("over_lamp", "over/lamp_ovr.png");
    public static final DBIcon OVER_RED_LAMP = new DBIcon("over_redlamp", "over/redlamp_ovr.png");
    public static final DBIcon OVER_KEY = new DBIcon("over_key", "over/key_ovr.png");
    public static final DBIcon OVER_LOCK = new DBIcon("over_lock", "over/lock_ovr.png");
    public static final DBIcon OVER_EXTERNAL = new DBIcon("over_external", "over/external_ovr.png");
    public static final DBIcon OVER_REFERENCE = new DBIcon("over_reference", "over/reference_ovr.png");
    public static final DBIcon OVER_FOLDER = new DBIcon("over_folder", "over/folder_ovr.png");
    public static final DBIcon DATABASE_DEFAULT = new DBIcon("database_icon_default", "connection/database_icon.png");
    public static final DBIcon DATABASE_BIG_DEFAULT = new DBIcon("database_icon_big_default", "connection/database_icon_big.png");
    public static final DBIcon APACHE = new DBIcon("apache", "misc/apache.png");
    public static final DBIcon JAR = new DBIcon("jar", "misc/jar.png");
    public static final DBIcon LIBRARY = new DBIcon("library", "misc/library.png");
    public static final DBIcon STATUS_ERROR = new DBIcon("status_error", "status/error.png");
    public static final DBIcon STATUS_WARNING = new DBIcon("status_warning", "status/warning.png");
    public static final DBIcon STATUS_QUESTION = new DBIcon("status_question", "status/question.png");
    public static final DBIcon STATUS_INFO = new DBIcon("status_info", "status/info.png");
    public static final DBIcon SMALL_ERROR = new DBIcon("small_error", "status/error_small.png");
    public static final DBIcon SMALL_WARNING = new DBIcon("small_warning", "status/warning_small.png");
    public static final DBIcon SMALL_QUESTION = new DBIcon("small_question", "status/question_small.png");
    public static final DBIcon SMALL_INFO = new DBIcon("small_info", "status/info_small.png");
    public static final DBIcon AI = new DBIcon("ai", "misc/ai.png");
    public static final DBIcon TINY_ERROR = new DBIcon("tiny_error", "status/error_tiny.png");
    private static final boolean VALIDATE_ICON_FILE = false;
    private static final Map<String, DBPImage> iconMap = new HashMap<String, DBPImage>();
    private final String token;
    private String path;

    static {
        DBIcon.loadIcons(DBIcon.class);
    }

    public static void loadIcons(Class<?> aClass) {
        Bundle iconBundle = FrameworkUtil.getBundle(aClass);
        if (iconBundle == null) {
            log.error("Can't find bundle for class '" + aClass.getName() + "'");
            return;
        }
        Field[] fieldArray = aClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 8) != 0 && field.getType() == DBIcon.class) {
                try {
                    DBIcon icon = (DBIcon)field.get(null);
                    if (!icon.path.startsWith("platform:")) {
                        icon.path = "platform:/plugin/" + iconBundle.getSymbolicName() + "/icons/" + icon.path;
                    }
                    iconMap.put(icon.getToken(), icon);
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            ++n2;
        }
    }

    public DBIcon(String path) {
        this.token = null;
        this.path = path;
    }

    public DBIcon(String token, String path) {
        this.token = token;
        this.path = path;
    }

    public static DBPImage getImageById(String token) {
        return iconMap.get(token);
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String getLocation() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBIcon) {
            return CommonUtils.equalObjects((Object)this.token, (Object)((DBIcon)obj).token) && CommonUtils.equalObjects((Object)this.path, (Object)((DBIcon)obj).path);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.token) + ":" + this.path;
    }
}

