/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBWHandlerConfiguration {
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    @NotNull
    private final DBWHandlerDescriptor descriptor;
    private DBPDataSourceContainer dataSource;
    private boolean enabled;
    private String userName;
    private String password;
    private boolean savePassword = true;
    private final Map<String, Object> properties;
    private final Map<String, String> secureProperties;

    public DBWHandlerConfiguration(@NotNull DBWHandlerDescriptor descriptor, DBPDataSourceContainer dataSource) {
        this.descriptor = descriptor;
        this.dataSource = dataSource;
        this.properties = new LinkedHashMap<String, Object>();
        this.secureProperties = new LinkedHashMap<String, String>();
    }

    public DBWHandlerConfiguration(@NotNull DBWHandlerConfiguration configuration) {
        this.descriptor = configuration.descriptor;
        this.dataSource = configuration.dataSource;
        this.enabled = configuration.enabled;
        this.userName = configuration.userName;
        this.password = configuration.password;
        this.savePassword = configuration.savePassword;
        this.properties = new LinkedHashMap<String, Object>(configuration.properties);
        this.secureProperties = new LinkedHashMap<String, String>(configuration.secureProperties);
    }

    @NotNull
    public DBWHandlerDescriptor getHandlerDescriptor() {
        return this.descriptor;
    }

    public <T extends DBWNetworkHandler> T createHandler(Class<T> type) throws DBException {
        try {
            return this.descriptor.createHandler(type);
        }
        catch (Exception e) {
            throw new DBException("Cannot create tunnel '" + this.descriptor.getLabel() + "'", e);
        }
    }

    public DBPDriver getDriver() {
        return this.dataSource == null ? null : this.dataSource.getDriver();
    }

    public DBPDataSourceContainer getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
    }

    public DBWHandlerType getType() {
        return this.descriptor.getType();
    }

    public boolean isSecured() {
        return this.descriptor.isSecured();
    }

    @NotNull
    public String getId() {
        return this.descriptor.getId();
    }

    public String getTitle() {
        return this.descriptor.getLabel();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    @Nullable
    public Object getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    @Nullable
    public String getStringProperty(@NotNull String name) {
        return CommonUtils.toString((Object)this.properties.get(name), null);
    }

    public int getIntProperty(@NotNull String name) {
        return CommonUtils.toInt((Object)this.properties.get(name));
    }

    public boolean getBooleanProperty(@NotNull String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(@NotNull String name, boolean defValue) {
        return CommonUtils.getBoolean((Object)this.properties.get(name), (boolean)defValue);
    }

    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Nullable
    public String getSecureProperty(@NotNull String name) {
        String value = this.secureProperties.get(name);
        if (value == null) {
            value = CommonUtils.toString((Object)this.properties.get(name), null);
        }
        return value;
    }

    @NotNull
    public Map<String, String> getSecureProperties() {
        return this.secureProperties;
    }

    public void setSecureProperty(@NotNull String name, @Nullable String value) {
        if (value == null) {
            this.secureProperties.remove(name);
        } else {
            this.secureProperties.put(name, value);
        }
    }

    public void setSecureProperties(@NotNull Map<String, String> secureProperties) {
        this.secureProperties.clear();
        this.secureProperties.putAll(secureProperties);
    }

    public Map<String, Object> saveToMap() {
        return this.saveToMap(false);
    }

    public Map<String, Object> saveToSecret() {
        return this.saveToMap(true);
    }

    private Map<String, Object> saveToMap(boolean ignoreSecureProperties) {
        LinkedHashMap<String, Object> handlerProps = new LinkedHashMap<String, Object>();
        if (!this.isSavePassword() && ignoreSecureProperties) {
            return handlerProps;
        }
        if (!CommonUtils.isEmpty((String)this.userName)) {
            handlerProps.put("user", this.userName);
        }
        if (!CommonUtils.isEmpty((String)this.password)) {
            handlerProps.put("password", this.password);
        }
        if (!CommonUtils.isEmpty(this.secureProperties)) {
            handlerProps.put("properties", this.secureProperties);
        }
        return handlerProps;
    }

    void loadFromMap(Map<String, Object> handlerMap) {
        this.userName = JSONUtils.getString(handlerMap, "user");
        this.password = JSONUtils.getString(handlerMap, "password");
        this.secureProperties.clear();
        this.secureProperties.putAll(JSONUtils.deserializeStringMap(handlerMap, "properties"));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBWHandlerConfiguration)) {
            return false;
        }
        DBWHandlerConfiguration source = (DBWHandlerConfiguration)obj;
        return CommonUtils.equalObjects((Object)this.descriptor, (Object)source.descriptor) && CommonUtils.equalObjects((Object)this.dataSource, (Object)source.dataSource) && this.enabled == source.enabled && CommonUtils.equalObjects((Object)this.userName, (Object)source.userName) && CommonUtils.equalObjects((Object)this.password, (Object)source.password) && this.savePassword == source.savePassword && CommonUtils.equalObjects(this.properties, source.properties) && CommonUtils.equalObjects(this.secureProperties, source.secureProperties);
    }

    public void resolveDynamicVariables(IVariableResolver variableResolver) {
        this.userName = GeneralUtils.replaceVariables(this.userName, variableResolver);
        this.password = GeneralUtils.replaceVariables(this.password, variableResolver);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (!(entry.getValue() instanceof String) || !CommonUtils.isNotEmpty((String)((String)entry.getValue()))) continue;
            entry.setValue(GeneralUtils.replaceVariables((String)entry.getValue(), variableResolver));
        }
        for (Map.Entry<String, Object> entry : this.secureProperties.entrySet()) {
            if (!CommonUtils.isNotEmpty((String)((String)entry.getValue()))) continue;
            entry.setValue(GeneralUtils.replaceVariables((String)entry.getValue(), variableResolver));
        }
    }

    public boolean hasValuableInfo() {
        return !CommonUtils.isEmpty((String)this.userName) || !CommonUtils.isEmpty((String)this.password) || !CommonUtils.isEmpty(this.properties) || !CommonUtils.isEmpty(this.secureProperties);
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

