/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexString;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultiWordRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;

public class DB2SQLDialect
extends JDBCSQLDialect
implements TPRuleProvider {
    private static final Log log = Log.getLog(DB2SQLDialect.class);
    public static final String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private static final boolean LOAD_ROUTINES_FROM_SYSCAT = false;

    public DB2SQLDialect() {
        super("Db2 for LUW", "db2_luw");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList(DB2Constants.ADVANCED_KEYWORDS));
        this.addFunctions(Arrays.asList(DB2Constants.ROUTINES));
        this.turnFunctionIntoKeyword("TRUNCATE");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    protected void loadFunctions(JDBCSession session, JDBCDatabaseMetaData metaData, Set<String> allFunctions) throws DBException, SQLException {
        if (allFunctions.isEmpty()) {
            super.loadFunctions(session, metaData, allFunctions);
        }
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        if (proc.getProcedureType() == DBSProcedureType.FUNCTION && proc instanceof DB2Routine && ((DB2Routine)proc).getFunctionType() == DB2Routine.FunctionType.T) {
            return "SELECT * FROM TABLE (" + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
        }
        return super.getStoredProcedureCallInitialClause(proc);
    }

    @NotNull
    protected String getProcedureCallEndClause(DBSProcedure procedure) {
        if (procedure.getProcedureType() == DBSProcedureType.FUNCTION) {
            if (procedure instanceof DB2Routine && ((DB2Routine)procedure).getFunctionType() == DB2Routine.FunctionType.T) {
                return ")";
            }
            return "FROM SYSIBM.SYSDUMMY1";
        }
        return super.getProcedureCallEndClause(procedure);
    }

    @Nullable
    public String getDualTableName() {
        return "SYSIBM.SYSDUMMY1";
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexString.INSTANCE;
    }

    public String getScriptDelimiterRedefiner() {
        return "--#SET TERMINATOR";
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<TPRule> rules, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.KEYWORDS) {
            TPTokenDefault keywordToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_KEYWORD);
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"ROW", "BEGIN"}, (TPToken)keywordToken));
            rules.add((TPRule)new SQLMultiWordRule(new String[]{"ROW", "END"}, (TPToken)keywordToken));
        }
    }

    public boolean supportsAliasInConditions() {
        return false;
    }
}

