/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class MultiPageAbstractEditor
extends MultiPageEditorPart {
    private ImageDescriptor curTitleImage;
    private final List<Image> oldImages = new ArrayList<Image>();
    private int activePageIndex = -1;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.getEditorInput() == null) {
            super.init(site, input);
        } else {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
        }
        this.setPartName(input.getName());
        this.setTitleImage(input.getImageDescriptor());
    }

    protected void setTitleImage(ImageDescriptor titleImage) {
        if (this.getContainer() != null && this.getContainer().isDisposed()) {
            return;
        }
        if (CommonUtils.equalObjects((Object)this.curTitleImage, (Object)titleImage)) {
            return;
        }
        this.curTitleImage = titleImage;
        Image editorImage = titleImage.createImage();
        this.oldImages.add(editorImage);
        super.setTitleImage(editorImage);
    }

    public void dispose() {
        for (Image img : this.oldImages) {
            UIUtils.dispose((Resource)img);
        }
        this.oldImages.clear();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createPages() {
        this.setContainerStyles();
    }

    protected void setContainerStyles() {
        Composite pageContainer = this.getContainer();
        if (pageContainer instanceof CTabFolder && !pageContainer.isDisposed()) {
            Layout parentLayout;
            CTabFolder tabFolder = (CTabFolder)pageContainer;
            tabFolder.setSimple(true);
            tabFolder.setMRUVisible(true);
            tabFolder.setTabPosition(128);
            Control topRight = this.createTopRightControl((Composite)tabFolder);
            if (topRight != null) {
                Point trSize = topRight.computeSize(-1, -1);
                tabFolder.setTabHeight(trSize.y);
                tabFolder.setTopRight(topRight, 131136);
            }
            if ((parentLayout = tabFolder.getParent().getLayout()) instanceof FillLayout) {
                ((FillLayout)parentLayout).marginHeight = 0;
            }
        }
    }

    protected void setPageToolTip(int index, String toolTip) {
        CTabFolder tabFolder;
        Composite pageContainer = this.getContainer();
        if (pageContainer instanceof CTabFolder && index < (tabFolder = (CTabFolder)pageContainer).getItemCount()) {
            tabFolder.getItem(index).setToolTipText(toolTip);
        }
    }

    protected void pageChange(int newPageIndex) {
        this.deactivateEditor();
        this.activePageIndex = newPageIndex;
        super.pageChange(newPageIndex);
        this.activateEditor();
    }

    protected final void deactivateEditor() {
        IEditorPart part;
        if (this.activePageIndex >= 0 && (part = this.getEditor(this.activePageIndex)) instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)part).deactivatePart();
        }
    }

    protected final void activateEditor() {
        int pageIndex = this.getActivePage();
        IEditorPart part = this.getEditor(pageIndex);
        if (part instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)part).activatePart();
        }
    }

    public IEditorPart getActiveEditor() {
        if (this.getContainer().isDisposed()) {
            return null;
        }
        return super.getActiveEditor();
    }

    protected IEditorPart getEditor(int pageIndex) {
        Object data;
        CTabItem item = ((CTabFolder)this.getContainer()).getItem(pageIndex);
        if (item != null && !item.isDisposed() && (data = item.getData()) instanceof IEditorPart) {
            return (IEditorPart)data;
        }
        return null;
    }

    protected Control createTopRightControl(Composite composite) {
        return null;
    }

    public void recreatePages() {
        int pageCount;
        int i = pageCount = this.getPageCount();
        while (i > 0) {
            this.removePage(i - 1);
            --i;
        }
        this.createPages();
    }
}

