/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedList;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.utils.CommonUtils;

public class AdvancedListItem
extends Canvas {
    private static final Log log = Log.getLog(AdvancedListItem.class);
    public static final int BORDER_MARGIN = 5;
    private final AdvancedList list;
    private final ILabelProvider labelProvider;
    private boolean isHover;

    public AdvancedListItem(AdvancedList list, Object item, ILabelProvider labelProvider) {
        super((Composite)list.getContainer(), 0x20000000);
        String toolTipText;
        this.labelProvider = labelProvider;
        this.list = list;
        this.list.addItem(this);
        this.setData(item);
        if (labelProvider instanceof IToolTipProvider && !CommonUtils.isEmpty((String)(toolTipText = ((IToolTipProvider)labelProvider).getToolTipText(item)))) {
            this.setToolTipText(toolTipText);
        }
        CSSUtils.setCSSClass((Widget)this, "Composite");
        this.setBackground(list.getContainer().getBackground());
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                AdvancedListItem.this.isHover = true;
                AdvancedListItem.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                AdvancedListItem.this.isHover = false;
                AdvancedListItem.this.redraw();
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AdvancedListItem.this.getList().notifyDefaultSelection();
            }

            public void mouseDown(MouseEvent e) {
                AdvancedListItem.this.getList().setSelection(AdvancedListItem.this);
                AdvancedListItem.this.setFocus();
            }
        });
        this.addPaintListener(this::painItem);
        this.addDisposeListener(e -> list.removeItem(this));
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AdvancedListItem.this.getList().getSelectedItem() == null) {
                    AdvancedListItem.this.getList().setSelection(AdvancedListItem.this);
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: {
                        if (AdvancedListItem.this.getList().getSelectedItem() == null) break;
                        AdvancedListItem.this.getList().navigateByKey(e);
                    }
                }
            }
        });
    }

    private void painItem(PaintEvent e) {
        String text;
        Point itemSize = this.getSize();
        boolean isSelected = this.getList().getSelectedItem() == this;
        GC gc = e.gc;
        if (isSelected) {
            gc.setBackground(this.getList().getSelectionBackgroundColor());
            gc.setForeground(this.getList().getSelectionForegroundColor());
        } else if (this.isHover) {
            gc.setBackground(this.getList().getHoverBackgroundColor());
            gc.setForeground(this.getList().getForegroundColor());
        } else {
            gc.setBackground(this.getList().getContainer().getBackground());
            gc.setForeground(this.getList().getForegroundColor());
        }
        if (isSelected || this.isHover) {
            gc.fillRoundRectangle(0, 0, itemSize.x, itemSize.y, 5, 5);
        }
        Image icon = this.labelProvider.getImage(this.getData());
        Rectangle iconBounds = icon.getBounds();
        Point imageSize = this.getList().getImageSize();
        int imgPosX = (itemSize.x - imageSize.x) / 2;
        int imgPosY = 5;
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(icon, 0, 0, iconBounds.width, iconBounds.height, imgPosX - e.x, imgPosY, imageSize.x, imageSize.y);
        String theText = text = this.labelProvider.getText(this.getData());
        int divPos = theText.indexOf(40);
        if (divPos != -1 && text.endsWith(")")) {
            String mainTitle = text.substring(0, divPos);
            String subTitle = text.substring(divPos, text.length());
            this.drawItemText(e, itemSize, gc, mainTitle, 0);
            this.drawItemText(e, itemSize, gc, subTitle, this.getList().getTextSize().y + 1);
        } else {
            this.drawItemText(e, itemSize, gc, text, 10);
        }
    }

    private void drawItemText(PaintEvent e, Point itemSize, GC gc, String theText, int topIndent) {
        Point textSize = gc.stringExtent(theText);
        if (textSize.x > itemSize.x - 10) {
            textSize.x = itemSize.x - 10;
        }
        gc.setClipping(5, itemSize.y - 20 - textSize.y + topIndent, itemSize.x - 10, textSize.y * 2);
        gc.drawText(theText, (itemSize.x - textSize.x) / 2 - e.x, itemSize.y - textSize.y - 20 + topIndent);
    }

    private AdvancedList getList() {
        return this.list;
    }

    public boolean isHover() {
        return this.isHover;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point imageSize = this.getList().getImageSize();
        int itemLength = imageSize.x + 20 + this.getList().getTextSize().y;
        return new Point(itemLength, itemLength);
    }

    private Image resize(Image image, int width, int height) {
        this.getDisplay();
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        return scaled;
    }
}

