/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class ExasolTablePartitionColumn
extends AbstractTableIndexColumn {
    private ExasolTable table;
    private int ordinalPosition;
    private ExasolTableColumn tableColumn;
    private static final Log log = Log.getLog(ExasolTablePartitionColumn.class);

    public ExasolTablePartitionColumn(ExasolTable table, ExasolTableColumn tableColumn, int ordinalPosition) {
        this.table = table;
        this.tableColumn = tableColumn;
        this.ordinalPosition = ordinalPosition;
    }

    public ExasolTablePartitionColumn(ExasolTable table) {
        this.table = table;
    }

    public ExasolTable getTable() {
        return this.table;
    }

    @Property(viewable=false)
    public DBSTableIndex getIndex() {
        return null;
    }

    @Property(viewable=true, updatable=true, editable=true, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    @Property(viewable=false)
    public boolean isAscending() {
        return false;
    }

    @Property(viewable=true, updatable=true, editable=true, order=1, listProvider=TableColumListProvider.class)
    public ExasolTableColumn getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(ExasolTableColumn tableColumn) {
        this.tableColumn = tableColumn;
    }

    @Property(viewable=false)
    public String getDescription() {
        if (this.tableColumn == null) {
            return null;
        }
        return this.tableColumn.getDescription();
    }

    public ExasolTable getParentObject() {
        return this.table;
    }

    public ExasolDataSource getDataSource() {
        return (ExasolDataSource)this.table.getDataSource();
    }

    @Property(viewable=false)
    public String getName() {
        if (this.tableColumn == null) {
            return null;
        }
        return this.tableColumn.getName();
    }

    public static class TableColumListProvider
    implements IPropertyValueListProvider<ExasolTablePartitionColumn> {
        public boolean allowCustomValue() {
            return true;
        }

        public Object[] getPossibleValues(ExasolTablePartitionColumn object) {
            try {
                return object.getTable().getAvailableColumns().toArray();
            }
            catch (DBException e) {
                log.error((Object)"Failed to get list of available columns", (Throwable)e);
                return new Object[0];
            }
        }
    }
}

