/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.Date;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTaskConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.task.TaskConfigurationImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class EditTaskConfigurationDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.EditTaskConfigurationDialog";
    private final DBPProject project;
    private final DBTTaskDescriptor taskDescriptor;
    private DBTTaskConfiguration configuration;
    private Map<String, Object> state;
    private Combo taskLabelCombo;
    private Text taskDescriptionText;
    private DBTTaskConfiguration[] allTasks;

    public EditTaskConfigurationDialog(Shell parentShell, DBPProject project, DBTTaskDescriptor taskDescriptor, Map<String, Object> state) {
        super(parentShell, "Create new task " + taskDescriptor.getName(), (DBPImage)DBIcon.TREE_PACKAGE);
        this.project = project;
        this.taskDescriptor = taskDescriptor;
        this.state = state;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        Composite labelPanel = UIUtils.createComposite((Composite)composite, (int)2);
        labelPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)labelPanel, (String)"Type", (String)this.taskDescriptor.getName(), (int)2056);
        this.taskLabelCombo = UIUtils.createLabelCombo((Composite)labelPanel, (String)"Task", (String)"", (int)2048);
        ModifyListener modifyListener = e -> this.updateButtons();
        this.taskLabelCombo.add("");
        DBTTaskManager taskManager = this.project.getTaskManager();
        DBTTaskConfiguration[] dBTTaskConfigurationArray = this.allTasks = taskManager.getTaskConfigurations(this.taskDescriptor);
        int n = this.allTasks.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskConfiguration tc = dBTTaskConfigurationArray[n2];
            this.taskLabelCombo.add(tc.getLabel());
            ++n2;
        }
        this.taskLabelCombo.addModifyListener(modifyListener);
        this.taskLabelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = EditTaskConfigurationDialog.this.taskLabelCombo.getSelectionIndex();
                if (selectionIndex == 0) {
                    EditTaskConfigurationDialog.this.configuration = null;
                    EditTaskConfigurationDialog.this.setTitle("Create task " + EditTaskConfigurationDialog.this.taskDescriptor.getName());
                } else {
                    EditTaskConfigurationDialog.this.configuration = EditTaskConfigurationDialog.this.allTasks[selectionIndex - 1];
                    EditTaskConfigurationDialog.this.taskDescriptionText.setText(CommonUtils.notEmpty((String)EditTaskConfigurationDialog.this.configuration.getDescription()));
                    EditTaskConfigurationDialog.this.setTitle("Edit task " + EditTaskConfigurationDialog.this.configuration.getLabel());
                }
            }
        });
        this.taskDescriptionText = UIUtils.createLabelText((Composite)composite, (String)"Description", (String)"", (int)2562);
        ((GridData)this.taskDescriptionText.getLayoutData()).heightHint = this.taskDescriptionText.getLineHeight() * 5;
        this.taskDescriptionText.addModifyListener(modifyListener);
        UIUtils.asyncExec(() -> {
            boolean bl = this.taskLabelCombo.setFocus();
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isReady = !this.taskLabelCombo.getText().isEmpty();
        this.getButton(0).setEnabled(isReady);
    }

    protected void okPressed() {
        DBTTaskManager taskManager = this.project.getTaskManager();
        if (this.configuration == null) {
            try {
                this.configuration = taskManager.createTaskConfiguration(this.taskDescriptor, this.taskLabelCombo.getText(), this.taskDescriptionText.getText(), this.state);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Create task", "Error creating data transfer task", (Throwable)e);
            }
        } else {
            TaskConfigurationImpl impl = (TaskConfigurationImpl)this.configuration;
            impl.setLabel(this.taskLabelCombo.getText());
            impl.setDescription(this.taskDescriptionText.getText());
            impl.setUpdateTime(new Date());
            impl.setProperties(this.state);
            taskManager.updateTaskConfiguration(this.configuration);
        }
        super.okPressed();
    }

    public DBTTaskConfiguration getTaskConfiguration() {
        return this.configuration;
    }
}

