/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.sql.SQLQueryResultsConsumer;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

class SQLQueryDataContainer
implements DBSDataContainer,
SQLQueryContainer,
DBPContextProvider {
    private SQLQueryJob queryJob;
    private SQLQueryResultsConsumer resultsConsumer;
    private SQLQuery query = null;
    private int resultSetNumber;
    private DBDDataReceiver dataReceiver;

    SQLQueryDataContainer(SQLQueryJob queryJob, SQLQueryResultsConsumer resultsConsumer, SQLQuery query, int resultSetNumber) {
        this.queryJob = queryJob;
        this.resultsConsumer = resultsConsumer;
        this.query = query;
        this.resultSetNumber = resultSetNumber;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.queryJob.getExecutionContext();
    }

    public int getSupportedFeatures() {
        return 0;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        SQLQuery query = this.query;
        if (query.getResultsMaxRows() >= 0) {
            firstRow = query.getResultsOffset();
            maxRows = query.getResultsMaxRows();
        }
        this.resultsConsumer.setDataReceiver(dataReceiver);
        if (this.resultSetNumber > 0) {
            this.queryJob.setFetchResultSetNumber(this.resultSetNumber);
        } else {
            this.queryJob.setFetchResultSetNumber(-1);
        }
        this.queryJob.setResultSetLimit(firstRow, maxRows);
        this.queryJob.setReadFlags(flags);
        this.queryJob.setDataFilter(dataFilter);
        this.queryJob.extractData(session, (SQLScriptElement)this.query, this.resultSetNumber);
        return this.queryJob.getStatistics();
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        return -1L;
    }

    @Nullable
    public String getDescription() {
        return SQLEditorMessages.editors_sql_description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.queryJob.getDataSourceContainer().getDataSource();
    }

    public boolean isPersisted() {
        return false;
    }

    @NotNull
    public String getName() {
        String name = this.query.getOriginalText();
        if (name == null) {
            name = "SQL";
        }
        return name;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.queryJob.getDataSourceContainer();
    }

    public String toString() {
        return this.query.getOriginalText();
    }

    public SQLScriptElement getQuery() {
        return this.query;
    }
}

