/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model.meta;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class GenericMetaModelDescriptor
extends AbstractDescriptor {
    private IConfigurationElement contributorConfig;
    private AbstractDescriptor.ObjectType implType;
    private GenericMetaModel instance;
    private String id;
    private final Map<String, GenericMetaObject> objects = new HashMap<String, GenericMetaObject>();
    private String[] driverClass;

    public GenericMetaModelDescriptor() {
        super("org.jkiss.dbeaver.ext.generic");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, GenericMetaModel.class.getName());
        this.instance = new GenericMetaModel();
        this.instance.descriptor = this;
    }

    public GenericMetaModelDescriptor(IConfigurationElement cfg) {
        super(cfg);
        String driverClassList;
        this.contributorConfig = cfg;
        this.id = cfg.getAttribute("id");
        Object[] objectList = cfg.getChildren("object");
        if (!ArrayUtils.isEmpty((Object[])objectList)) {
            Object[] objectArray = objectList;
            int n = objectList.length;
            int n2 = 0;
            while (n2 < n) {
                Object childConfig = objectArray[n2];
                GenericMetaObject metaObject = new GenericMetaObject((IConfigurationElement)childConfig);
                this.objects.put(metaObject.getType(), metaObject);
                ++n2;
            }
        }
        this.driverClass = CommonUtils.isEmpty((String)(driverClassList = cfg.getAttribute("driverClass"))) ? new String[0] : driverClassList.split(",");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, cfg.getAttribute("class"));
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String[] getDriverClass() {
        return this.driverClass;
    }

    public GenericMetaObject getObject(String id) {
        return this.objects.get(id);
    }

    public GenericMetaModel getInstance() throws DBException {
        if (this.instance != null) {
            return this.instance;
        }
        Class implClass = this.implType.getObjectClass(GenericMetaModel.class);
        if (implClass == null) {
            throw new DBException("Can't create generic meta model instance '" + this.implType.getImplName() + "'");
        }
        try {
            this.instance = (GenericMetaModel)implClass.newInstance();
        }
        catch (Throwable e) {
            throw new DBException("Can't instantiate meta model", e);
        }
        this.instance.descriptor = this;
        return this.instance;
    }
}

