/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.time.format.DateTimeFormatter;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCTemporalAccessorValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleTemporalAccessorValueHandler
extends JDBCTemporalAccessorValueHandler {
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMAT = DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.nnnnnn''");
    private static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFormatter.ofPattern("'DATE '''yyyy-MM-dd''");
    private static final DateTimeFormatter DEFAULT_TIME_FORMAT = DateTimeFormatter.ofPattern("'TIME '''HH:mm:ss.SSS''");

    public OracleTemporalAccessorValueHandler(DBDDataFormatterProfile formatterProfile) {
        super(formatterProfile);
    }

    @Nullable
    public DateTimeFormatter getNativeValueFormat(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 93: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 101: 
            case 102: 
            case 2014: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 92: {
                return DEFAULT_TIME_FORMAT;
            }
            case 2013: {
                return DEFAULT_TIME_FORMAT;
            }
            case 91: {
                return DEFAULT_DATE_FORMAT;
            }
        }
        return super.getNativeValueFormat(type);
    }

    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeID()) {
            case 101: 
            case 102: {
                return "timestamp";
            }
        }
        return super.getFormatterId(column);
    }

    protected boolean isZonedType(DBSTypedObject type) {
        if (type.getTypeID() == 101) {
            return true;
        }
        return super.isZonedType(type);
    }
}

