/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.registry.PluginServiceRegistry;
import org.jkiss.dbeaver.registry.datatype.DataTypeProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.jobs.KeepAliveJob;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class BasePlatformImpl
implements DBPPlatform {
    private static final Log log = Log.getLog(BasePlatformImpl.class);
    private static final String APP_CONFIG_FILE = "dbeaver.ini";
    private static final String ECLIPSE_CONFIG_FILE = "eclipse.ini";
    private DBPPlatformLanguage language;
    private OSDescriptor localSystem;
    private DBNModel navigatorModel;
    private final List<IPluginService> activatedServices = new ArrayList<IPluginService>();

    protected void initialize() {
        log.debug((Object)"Initialize base platform...");
        DBPPreferenceStore prefsStore = this.getPreferenceStore();
        prefsStore.addPropertyChangeListener(event -> {
            for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                ds.getPreferenceStore().firePropertyChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        });
        this.localSystem = new OSDescriptor(Platform.getOS(), Platform.getOSArch());
        this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.language == null) {
            log.debug((Object)("Language for locale '" + Locale.getDefault() + "' not found. Use default."));
            this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        this.navigatorModel = new DBNModel((DBPPlatform)this, true);
        this.navigatorModel.initialize();
        this.activateProxyService();
        for (IPluginService pluginService : PluginServiceRegistry.getInstance().getServices()) {
            try {
                pluginService.activateService();
                this.activatedServices.add(pluginService);
            }
            catch (Throwable e) {
                log.error((Object)"Error activating plugin service", e);
            }
        }
        new KeepAliveJob((DBPPlatform)this).scheduleMonitor();
    }

    public synchronized void dispose() {
        for (IPluginService pluginService : this.activatedServices) {
            try {
                pluginService.deactivateService();
            }
            catch (Exception e) {
                log.error((Object)"Error deactivating plugin service", (Throwable)e);
            }
        }
        this.activatedServices.clear();
        if (this.navigatorModel != null) {
            this.navigatorModel.dispose();
        }
    }

    @NotNull
    public DBDRegistry getValueHandlerRegistry() {
        return DataTypeProviderRegistry.getInstance();
    }

    @NotNull
    public DBERegistry getEditorsRegistry() {
        return ObjectManagerRegistry.getInstance();
    }

    @NotNull
    public DBPDataFormatterRegistry getDataFormatterRegistry() {
        return DataFormatterRegistry.getInstance();
    }

    @NotNull
    public OSDescriptor getLocalSystem() {
        return this.localSystem;
    }

    @NotNull
    public DBPPlatformLanguage getLanguage() {
        return this.language;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        File configPath;
        if (CommonUtils.equalObjects((Object)language, (Object)this.language)) {
            return;
        }
        try {
            configPath = RuntimeUtils.getLocalFileFromURL((URL)Platform.getInstallLocation().getURL());
        }
        catch (IOException e) {
            throw new DBException("Can't detect application installation folder.", (Throwable)e);
        }
        File iniFile = new File(configPath, ECLIPSE_CONFIG_FILE);
        if (!iniFile.exists()) {
            iniFile = new File(configPath, APP_CONFIG_FILE);
        }
        if (!iniFile.exists()) {
            throw new DBException("Application configuration file (" + iniFile.getAbsolutePath() + ") not found. Default language cannot be changed.");
        }
        try {
            List<String> configLines = Files.readAllLines(iniFile.toPath());
            this.setConfigNLS(configLines, language.getCode());
            Files.write(iniFile.toPath(), configLines, StandardOpenOption.WRITE);
            this.language = language;
            this.getPreferenceStore().setValue("platform.language", language.getCode());
        }
        catch (AccessDeniedException e) {
            throw new DBException("Can't save startup configuration - access denied.\nYou could try to change national locale manually in '" + iniFile.getAbsolutePath() + "'. Refer to readme.txt file for details.", (Throwable)e);
        }
        catch (Exception e) {
            throw new DBException("Unexpected error while saving startup configuration", (Throwable)e);
        }
    }

    @NotNull
    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    @NotNull
    public DBPDataSourceProviderRegistry getDataSourceProviderRegistry() {
        return DataSourceProviderRegistry.getInstance();
    }

    @NotNull
    public File getCustomDriversHome() {
        return DriverDescriptor.getCustomDriversHome();
    }

    private void activateProxyService() {
        try {
            log.debug((Object)("Proxy service '" + IProxyService.class.getName() + "' loaded"));
        }
        catch (Throwable throwable) {
            log.debug((Object)"Proxy service not found");
        }
    }

    private void setConfigNLS(List<String> lines, String nl) {
        int vmArgsPos = -1;
        int nlPos = -1;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i).trim();
            if (line.equalsIgnoreCase("-nl")) {
                nlPos = i;
            } else if (line.equalsIgnoreCase("-vmargs")) {
                vmArgsPos = i;
                break;
            }
            ++i;
        }
        if (nlPos >= 0 && lines.size() > nlPos + 1) {
            lines.set(nlPos + 1, nl);
        } else if (vmArgsPos >= 0) {
            lines.add(vmArgsPos, nl);
            lines.add(vmArgsPos, "-nl");
        } else {
            lines.add("-nl");
            lines.add(nl);
        }
    }
}

