/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskConfigurator;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskTypeDescriptor;
import org.jkiss.dbeaver.registry.task.TaskConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.task.TaskDescriptor;

public class TaskTypeDescriptor
extends AbstractContextDescriptor
implements DBTTaskTypeDescriptor,
DBPNamedObjectLocalized {
    private final IConfigurationElement config;
    private final List<TaskDescriptor> tasks = new ArrayList<TaskDescriptor>();
    private TaskConfiguratorDescriptor configuratorDescriptor;

    TaskTypeDescriptor(IConfigurationElement config) {
        super(config);
        this.config = config;
    }

    void addTask(TaskDescriptor task) {
        this.tasks.add(task);
    }

    @NotNull
    public String getId() {
        return this.config.getAttribute("id");
    }

    @NotNull
    public String getName() {
        return this.config.getAttribute("name");
    }

    public String getDescription() {
        return this.config.getAttribute("description");
    }

    public DBPImage getIcon() {
        return this.iconToImage(this.config.getAttribute("icon"));
    }

    @NotNull
    public DBTTaskDescriptor[] getTasks() {
        return this.tasks.toArray(new DBTTaskDescriptor[0]);
    }

    public boolean supportsConfigurator() {
        return this.configuratorDescriptor != null;
    }

    @NotNull
    public DBTTaskConfigurator createConfigurator() throws DBException {
        if (this.configuratorDescriptor == null) {
            throw new DBException("No configurator for task type " + this.getId());
        }
        return this.configuratorDescriptor.createConfigurator();
    }

    void setConfigurator(TaskConfiguratorDescriptor configurator) {
        this.configuratorDescriptor = configurator;
    }

    public String toString() {
        return this.getId();
    }

    public String getLocalizedName(String locale) {
        return this.config.getAttribute("name", locale);
    }
}

