/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Comparator;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreAttribute<OWNER extends DBSEntity & PostgreObject>
extends JDBCTableColumn<OWNER>
implements PostgreObject,
DBSTypedObjectEx,
DBPNamedObject2,
DBPHiddenObject,
DBPInheritedObject {
    private static final Log log = Log.getLog(PostgreAttribute.class);
    @NotNull
    private PostgreDataType dataType;
    private String comment;
    private long charLength;
    private int arrayDim;
    private int inheritorsCount;
    private String description;
    @Nullable
    private PostgreAttributeIdentity identity;
    private boolean isLocal;
    private long objectId;
    private long collationId;
    private Object acl;

    protected PostgreAttribute(OWNER table) {
        super(table, false);
        this.isLocal = true;
    }

    public PostgreAttribute(DBRProgressMonitor monitor, OWNER table, JDBCResultSet dbResult) throws DBException {
        super(table, true);
        this.loadInfo(monitor, dbResult);
    }

    public PostgreAttribute(DBRProgressMonitor monitor, OWNER table, PostgreAttribute source) throws DBException {
        super(table, (DBSEntityAttribute)source, true);
        this.dataType = source.dataType;
        this.comment = source.comment;
        this.charLength = source.charLength;
        this.arrayDim = source.arrayDim;
        this.inheritorsCount = source.inheritorsCount;
        this.description = source.description;
        this.identity = source.identity;
        this.isLocal = source.isLocal;
        this.collationId = source.collationId;
        this.acl = source.acl;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreObject)this.getTable()).getDatabase();
    }

    @Property(viewable=false, order=26)
    public long getObjectId() {
        return this.objectId;
    }

    private void loadInfo(DBRProgressMonitor monitor, JDBCResultSet dbResult) throws DBException {
        String identityStr;
        PostgreDataSource dataSource = this.getDataSource();
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attnum"));
        this.setRequired(JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"attnotnull"));
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attr_id");
        long typeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"atttypid");
        this.dataType = ((PostgreObject)this.getTable()).getDatabase().getDataType(monitor, typeId);
        if (this.dataType == null) {
            log.error((Object)("Attribute data type '" + typeId + "' not found. Use " + "varchar"));
            this.dataType = ((PostgreObject)this.getTable()).getDatabase().getDataType(monitor, "varchar");
        }
        this.setValueType(this.dataType.getTypeID());
        this.setDefaultValue(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"def_value"));
        int typeMod = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"atttypmod");
        int maxLength = PostgreUtils.getAttributePrecision(typeId, typeMod);
        DBPDataKind dataKind = this.dataType.getDataKind();
        if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME) {
            this.setMaxLength(0L);
        } else {
            if (maxLength <= 0) {
                maxLength = PostgreUtils.getDisplaySize(typeId, typeMod);
            }
            if (maxLength >= 0) {
                this.setMaxLength(maxLength);
            }
        }
        this.setPrecision(maxLength);
        this.setScale(PostgreUtils.getScale(typeId, typeMod));
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.arrayDim = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attndims");
        this.inheritorsCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attinhcount");
        boolean bl = this.isLocal = !dataSource.getServerType().supportsInheritance() || JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"attislocal", (boolean)true);
        if (dataSource.isServerVersionAtLeast(10, 0) && !CommonUtils.isEmpty((String)(identityStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attidentity")))) {
            this.identity = PostgreAttributeIdentity.getByCode(identityStr);
        }
        if (dataSource.getServerType().supportsCollations()) {
            this.collationId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attcollation");
        }
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"attacl");
        this.setPersisted(true);
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return ((PostgreObject)this.getTable()).getDataSource();
    }

    public Object getAcl() {
        return this.acl;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=DataTypeListProvider.class, valueTransformer=DataTypeValueTransformer.class)
    @NotNull
    public PostgreDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(@NotNull PostgreDataType dataType) {
        this.dataType = dataType;
        this.setTypeName(dataType.getTypeName());
        this.setValueType(dataType.getTypeID());
    }

    public DBPDataKind getDataKind() {
        return this.dataType == null ? super.getDataKind() : this.dataType.getDataKind();
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=25)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    public String getTypeName() {
        return this.dataType == null ? super.getTypeName() : this.dataType.getTypeName();
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=26)
    public Integer getPrecision() {
        return super.getPrecision();
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=27)
    public Integer getScale() {
        return super.getScale();
    }

    @Property(viewable=true, editable=true, order=28)
    @Nullable
    public PostgreAttributeIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(PostgreAttributeIdentity identity) {
        this.identity = identity;
    }

    @Property(order=29)
    public boolean isLocal() {
        return this.isLocal;
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    public boolean isAutoGenerated() {
        if (this.identity != null) {
            return true;
        }
        String def = this.getDefaultValue();
        return def != null && def.contains("nextval(");
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property(viewable=true, editable=true, order=30, listProvider=CollationListProvider.class)
    public PostgreCollation getCollation(DBRProgressMonitor monitor) throws DBException {
        if (this.collationId <= 0L) {
            return null;
        }
        return this.getDatabase().getCollation(monitor, this.collationId);
    }

    public void setCollation(PostgreCollation collation) {
        this.collationId = collation == null ? 0L : collation.getObjectId();
    }

    public boolean isHidden() {
        return this.isPersisted() && this.getOrdinalPosition() < 0;
    }

    public boolean isInherited() {
        return !this.isLocal;
    }

    public String getFullTypeName() {
        if (this.dataType == null) {
            return super.getFullTypeName();
        }
        String fqtn = this.dataType.getTypeName();
        if (this.dataType.getDataKind() != DBPDataKind.CONTENT) {
            return DBUtils.getFullTypeName((DBSTypedObject)this);
        }
        return fqtn;
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<PostgreAttribute> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreAttribute object) {
            try {
                return object.getDatabase().getCollations((DBRProgressMonitor)new VoidProgressMonitor()).toArray();
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class DataTypeListProvider
    implements IPropertyValueListProvider<PostgreAttribute> {
        public boolean allowCustomValue() {
            return true;
        }

        public Object[] getPossibleValues(PostgreAttribute column) {
            TreeSet<PostgreDataType> types = new TreeSet<PostgreDataType>(Comparator.comparing(JDBCDataType::getTypeName));
            types.addAll(column.getDataSource().getLocalDataTypes());
            return types.toArray(new PostgreDataType[types.size()]);
        }
    }

    public static class DataTypeValueTransformer
    implements IPropertyValueTransformer<PostgreAttribute, Object> {
        public PostgreDataType transform(PostgreAttribute object, Object value) {
            if (value instanceof String) {
                PostgreDataType dataType = object.getDataSource().getLocalDataType((String)value);
                if (dataType == null && (dataType = object.getDatabase().getDataType(null, (String)value)) == null) {
                    throw new IllegalArgumentException("Bad data type name specified: " + value);
                }
                return dataType;
            }
            if (value instanceof PostgreDataType) {
                return (PostgreDataType)value;
            }
            throw new IllegalArgumentException("Invalid type value: " + value);
        }
    }
}

