/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePartition;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreServerExtensionBase
implements PostgreServerExtension {
    private static final Log log = Log.getLog(PostgreServerExtensionBase.class);
    protected final PostgreDataSource dataSource;

    protected PostgreServerExtensionBase(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean supportsOids() {
        return true;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsPartitions() {
        return this.dataSource.isServerVersionAtLeast(10, 0);
    }

    @Override
    public boolean supportsInheritance() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsRules() {
        return true;
    }

    @Override
    public boolean supportsExtensions() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    @Override
    public boolean supportsEncodings() {
        return true;
    }

    @Override
    public boolean supportsCollations() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsRoles() {
        return this.dataSource.isServerVersionAtLeast(8, 1);
    }

    @Override
    public boolean supportsSessionActivity() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsLocks() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsForeignServers() {
        return this.dataSource.isServerVersionAtLeast(8, 4);
    }

    @Override
    public boolean supportsAggregates() {
        return true;
    }

    @Override
    public boolean isSupportsLimits() {
        return true;
    }

    @Override
    public boolean supportsClientInfo() {
        return true;
    }

    @Override
    public String readTableDDL(DBRProgressMonitor monitor, PostgreTableBase table) throws DBException {
        return null;
    }

    @Override
    public boolean supportsTemplates() {
        return true;
    }

    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new PostgreDatabase.SchemaCache();
    }

    @Override
    public PostgreTableBase createRelationOfClass(PostgreSchema schema, PostgreClass.RelKind kind, JDBCResultSet dbResult) {
        if (kind == PostgreClass.RelKind.r) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.R) {
            return new PostgreTablePartition(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.v) {
            return new PostgreView(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new PostgreMaterializedView(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.f) {
            return new PostgreTableForeign(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.S) {
            return new PostgreSequence(schema, dbResult);
        }
        if (kind == PostgreClass.RelKind.t) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.p) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        log.warn((Object)("Unsupported PostgreClass '" + kind + "'"));
        return null;
    }

    @Override
    public PostgreTableBase createNewRelation(DBRProgressMonitor monitor, PostgreSchema schema, PostgreClass.RelKind kind, Object copyFrom) throws DBException {
        if (kind == PostgreClass.RelKind.v) {
            return new PostgreView(schema);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new PostgreMaterializedView(schema);
        }
        if (kind == PostgreClass.RelKind.f) {
            return new PostgreTableForeign(schema);
        }
        if (kind == PostgreClass.RelKind.S) {
            return new PostgreSequence(schema);
        }
        if (copyFrom instanceof PostgreTableRegular) {
            return new PostgreTableRegular(monitor, schema, (PostgreTableRegular)copyFrom);
        }
        return new PostgreTableRegular(schema);
    }

    @Override
    public boolean supportsRelationSizeCalc() {
        return true;
    }

    @Override
    public boolean supportFunctionDefRead() {
        return this.dataSource.isServerVersionAtLeast(8, 4);
    }

    @Override
    public void configureDialect(PostgreDialect dialect) {
    }

    @Override
    public String getTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, boolean alter) {
        PostgreTable table;
        StringBuilder ddl = new StringBuilder();
        if (tableBase instanceof PostgreTable) {
            table = (PostgreTable)tableBase;
            if (!alter) {
                try {
                    List<PostgreTableInheritance> superTables = table.getSuperInheritance(monitor);
                    if (!CommonUtils.isEmpty(superTables) && !tableBase.isPartition()) {
                        ddl.append("\nINHERITS (");
                        int i = 0;
                        while (i < superTables.size()) {
                            if (i > 0) {
                                ddl.append(",");
                            }
                            ddl.append(superTables.get(i).getAssociatedEntity().getFullyQualifiedName(DBPEvaluationContext.DDL));
                            ++i;
                        }
                        ddl.append(")");
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
                if (!CommonUtils.isEmpty((String)table.getPartitionKey())) {
                    ddl.append("\nPARTITION BY ").append(table.getPartitionKey());
                }
            }
            if (tableBase instanceof PostgreTablePartition && !alter) {
                ddl.append(((PostgreTablePartition)tableBase).getPartitionExpression());
            }
        }
        if (tableBase instanceof PostgreTableRegular) {
            table = (PostgreTableRegular)tableBase;
            try {
                if (!alter) {
                    ddl.append(this.createWithClause((PostgreTableRegular)table, tableBase));
                }
                boolean hasOtherSpecs = false;
                PostgreTablespace tablespace = table.getTablespace(monitor);
                if (tablespace != null && table.isTablespaceSpecified()) {
                    if (!alter) {
                        ddl.append("\nTABLESPACE ").append(tablespace.getName());
                    }
                    hasOtherSpecs = true;
                }
                if (!alter && hasOtherSpecs) {
                    ddl.append("\n");
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else if (tableBase instanceof PostgreTableForeign) {
            table = (PostgreTableForeign)tableBase;
            try {
                Object[] foreignOptions;
                PostgreForeignServer foreignServer;
                String foreignServerName = ((PostgreTableForeign)table).getForeignServerName();
                if (CommonUtils.isEmpty((String)foreignServerName) && (foreignServer = ((PostgreTableForeign)table).getForeignServer(monitor)) != null) {
                    foreignServerName = DBUtils.getQuotedIdentifier((DBSObject)foreignServer);
                }
                if (foreignServerName != null) {
                    ddl.append("\nSERVER ").append(foreignServerName);
                }
                if (!ArrayUtils.isEmpty((Object[])(foreignOptions = ((PostgreTableForeign)table).getForeignOptions(monitor)))) {
                    ddl.append("\nOPTIONS ").append(PostgreUtils.getOptionsString((String[])foreignOptions));
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        tableBase.appendTableModifiers(monitor, ddl);
        return ddl.toString();
    }

    @Override
    public PostgreTableColumn createTableColumn(DBRProgressMonitor monitor, PostgreSchema schema, PostgreTableBase table, JDBCResultSet dbResult) throws DBException {
        return new PostgreTableColumn(monitor, table, dbResult);
    }

    @Override
    public void initDefaultSSLConfig(DBPConnectionConfiguration connectionInfo, Map<String, String> props) {
        if (connectionInfo.getProperty("ssl") == null) {
            props.put("ssl", "false");
        }
    }

    @Override
    public List<PostgrePrivilege> readObjectPermissions(DBRProgressMonitor monitor, PostgreTableBase object, boolean includeNestedObjects) throws DBException {
        List<PostgrePrivilege> tablePermissions = PostgreUtils.extractPermissionsFromACL(monitor, object, object.getAcl());
        if (!includeNestedObjects) {
            return tablePermissions;
        }
        tablePermissions = new ArrayList<PostgrePrivilege>(tablePermissions);
        for (PostgreTableColumn column : CommonUtils.safeCollection(object.getAttributes(monitor))) {
            if (column.getAcl() == null || column.isHidden()) continue;
            tablePermissions.addAll(column.getPrivileges(monitor, true));
        }
        return tablePermissions;
    }

    @Override
    public boolean supportsExplainPlan() {
        return true;
    }

    @Override
    public boolean supportsExplainPlanXML() {
        return this.dataSource.isServerVersionAtLeast(9, 0);
    }

    @Override
    public boolean supportsExplainPlanVerbose() {
        return true;
    }

    @Override
    public boolean supportsDatabaseDescription() {
        return this.dataSource.isServerVersionAtLeast(9, 4);
    }

    @Override
    public boolean supportsTemporalAccessor() {
        return false;
    }

    @Override
    public boolean supportsTeblespaceLocation() {
        return this.dataSource.isServerVersionAtLeast(9, 2);
    }

    public String createWithClause(PostgreTableRegular table, PostgreTableBase tableBase) {
        StringBuilder withClauseBuilder = new StringBuilder();
        if (((PostgreDataSource)table.getDataSource()).getServerType().supportsOids() && table.isHasOids()) {
            withClauseBuilder.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
            withClauseBuilder.append("\n)");
        }
        return withClauseBuilder.toString();
    }
}

