/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.utils.ArrayUtils;

public class DataTransferSettings {
    private static final Log log = Log.getLog(DataTransferSettings.class);
    public static final int DEFAULT_THREADS_NUM = 1;
    private List<DataTransferPipe> dataPipes;
    private DataTransferNodeDescriptor producer;
    private DataTransferNodeDescriptor consumer;
    private final Map<DataTransferNodeDescriptor, IDataTransferSettings> nodeSettings = new HashMap<DataTransferNodeDescriptor, IDataTransferSettings>();
    private DataTransferProcessorDescriptor processor;
    private Map<DataTransferProcessorDescriptor, Map<Object, Object>> processorPropsHistory = new HashMap<DataTransferProcessorDescriptor, Map<Object, Object>>();
    private boolean producerProcessor;
    private final IDataTransferProducer[] initProducers;
    @Nullable
    private final IDataTransferConsumer[] initConsumers;
    private final List<DBSObject> initObjects = new ArrayList<DBSObject>();
    private boolean consumerOptional;
    private boolean producerOptional;
    private int maxJobCount = 1;
    private transient int curPipeNum = 0;
    private boolean showFinalMessage = true;

    public DataTransferSettings(@Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers) {
        int n;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray;
        this.initProducers = producers == null ? null : producers.toArray(new IDataTransferProducer[0]);
        this.initConsumers = consumers == null ? null : consumers.toArray(new IDataTransferConsumer[0]);
        this.dataPipes = new ArrayList<DataTransferPipe>();
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (!ArrayUtils.isEmpty((Object[])this.initProducers) && !ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            if (this.initProducers.length != this.initConsumers.length) {
                throw new IllegalArgumentException("Producers number must match consumers number");
            }
            int i = 0;
            while (i < this.initProducers.length) {
                if (this.initProducers[i].getDatabaseObject() != null) {
                    this.initObjects.add(this.initProducers[i].getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(this.initProducers[i], this.initConsumers[i]));
                ++i;
            }
            this.consumerOptional = false;
        } else if (!ArrayUtils.isEmpty((Object[])this.initProducers)) {
            iDataTransferNodeArray = this.initProducers;
            n = this.initProducers.length;
            int n2 = 0;
            while (n2 < n) {
                IDataTransferNode source = iDataTransferNodeArray[n2];
                if (source.getDatabaseObject() != null) {
                    this.initObjects.add(source.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe((IDataTransferProducer)source, null));
                ++n2;
            }
            Class<?> producerType = this.dataPipes.get(0).getProducer().getClass();
            DataTransferNodeDescriptor producerDesc = registry.getNodeByType(producerType);
            if (producerDesc != null) {
                this.selectProducer(producerDesc);
                this.consumerOptional = true;
            } else {
                DBWorkbench.getPlatformUI().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
        } else if (!ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            iDataTransferNodeArray = this.initConsumers;
            n = this.initConsumers.length;
            int producerDesc = 0;
            while (producerDesc < n) {
                IDataTransferNode target = iDataTransferNodeArray[producerDesc];
                if (target.getDatabaseObject() != null) {
                    this.initObjects.add(target.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(null, (IDataTransferConsumer)target));
                ++producerDesc;
            }
            Class<?> consumerType = this.dataPipes.get(0).getConsumer().getClass();
            DataTransferNodeDescriptor consumerDesc = registry.getNodeByType(consumerType);
            if (consumerDesc != null) {
                this.selectConsumer(consumerDesc, null, false);
                this.consumerOptional = false;
            } else {
                DBWorkbench.getPlatformUI().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
            this.producerOptional = true;
        } else {
            throw new IllegalArgumentException("Producers or consumers must be specified");
        }
        if (!ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            iDataTransferNodeArray = this.initConsumers;
            n = this.initConsumers.length;
            int n3 = 0;
            while (n3 < n) {
                IDataTransferNode target = iDataTransferNodeArray[n3];
                DataTransferNodeDescriptor node = registry.getNodeByType(target.getClass());
                if (node != null) {
                    this.consumer = node;
                }
                ++n3;
            }
        }
    }

    public boolean isConsumerOptional() {
        return this.consumerOptional;
    }

    public boolean isProducerOptional() {
        return this.producerOptional;
    }

    public IDataTransferNode[] getInitProducers() {
        return this.initProducers;
    }

    @Nullable
    public IDataTransferConsumer[] getInitConsumers() {
        return this.initConsumers;
    }

    public List<DBSObject> getSourceObjects() {
        return this.initObjects;
    }

    @Nullable
    public IDataTransferSettings getNodeSettings(DataTransferNodeDescriptor node) {
        IDataTransferSettings settings = this.nodeSettings.get((Object)node);
        if (settings == null) {
            try {
                settings = node.createSettings();
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
            this.nodeSettings.put(node, settings);
        }
        return settings;
    }

    public Map<DataTransferProcessorDescriptor, Map<Object, Object>> getProcessorPropsHistory() {
        return this.processorPropsHistory;
    }

    public Map<Object, Object> getProcessorProperties() {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        return this.processorPropsHistory.get((Object)this.processor);
    }

    public void setProcessorProperties(Map<Object, Object> properties) {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        this.processorPropsHistory.put(this.processor, properties);
    }

    public List<DataTransferPipe> getDataPipes() {
        return this.dataPipes;
    }

    public synchronized DataTransferPipe acquireDataPipe(DBRProgressMonitor monitor) {
        if (this.curPipeNum >= this.dataPipes.size()) {
            if (!this.dataPipes.isEmpty()) {
                this.dataPipes.get(this.dataPipes.size() - 1).getConsumer().finishTransfer(monitor, true);
            }
            return null;
        }
        DataTransferPipe result = this.dataPipes.get(this.curPipeNum);
        ++this.curPipeNum;
        return result;
    }

    public DataTransferNodeDescriptor getProducer() {
        return this.producer;
    }

    public void setProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    public DataTransferNodeDescriptor getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DataTransferNodeDescriptor consumer) {
        this.consumer = consumer;
    }

    public DataTransferProcessorDescriptor getProcessor() {
        return this.processor;
    }

    public boolean isProducerProcessor() {
        return this.producerProcessor;
    }

    private void selectProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    public void selectConsumer(DataTransferNodeDescriptor consumer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.consumer = consumer;
        this.processor = processor;
        this.producerProcessor = false;
        if (consumer != null && processor != null && !this.processorPropsHistory.containsKey((Object)processor)) {
            this.processorPropsHistory.put(processor, new HashMap());
        }
        int i = 0;
        while (i < this.dataPipes.size()) {
            DataTransferPipe pipe = this.dataPipes.get(i);
            if (rewrite || pipe.getConsumer() == null) {
                if (consumer != null) {
                    try {
                        IDataTransferConsumer consumerNode = (IDataTransferConsumer)consumer.createNode();
                        pipe.setConsumer(consumerNode);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                        pipe.setConsumer(null);
                    }
                } else {
                    pipe.setConsumer(null);
                }
            }
            ++i;
        }
    }

    public void selectProducer(DataTransferNodeDescriptor producer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.producer = producer;
        this.processor = processor;
        if (producer != null && processor != null) {
            this.producerProcessor = true;
            if (!this.processorPropsHistory.containsKey((Object)processor)) {
                this.processorPropsHistory.put(processor, new HashMap());
            }
        }
        for (DataTransferPipe pipe : this.dataPipes) {
            if (!rewrite && pipe.getProducer() != null) continue;
            if (producer != null) {
                try {
                    pipe.setProducer((IDataTransferProducer)producer.createNode());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    pipe.setProducer(null);
                }
                continue;
            }
            pipe.setProducer(null);
        }
    }

    public int getMaxJobCount() {
        return this.maxJobCount;
    }

    public void setMaxJobCount(int maxJobCount) {
        if (maxJobCount > 0) {
            this.maxJobCount = maxJobCount;
        }
    }

    public boolean isShowFinalMessage() {
        return this.showFinalMessage;
    }

    public void setShowFinalMessage(boolean showFinalMessage) {
        this.showFinalMessage = showFinalMessage;
    }
}

