/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.util.Map;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerSettings
implements IDataTransferSettings {
    public static final String PROP_EXTRACT_IMAGES = "extractImages";
    public static final String PROP_FILE_EXTENSION = "extension";
    public static final String PROP_FORMAT = "format";
    private LobExtractType lobExtractType = LobExtractType.SKIP;
    private LobEncoding lobEncoding = LobEncoding.HEX;
    private String outputFolder = System.getProperty("user.home");
    private String outputFilePattern = String.valueOf(GeneralUtils.variablePattern((String)"table")) + "_" + GeneralUtils.variablePattern((String)"timestamp");
    private String outputEncoding = GeneralUtils.getDefaultFileEncoding();
    private boolean outputEncodingBOM = false;
    private DBDDataFormatterProfile formatterProfile;
    private boolean outputClipboard = false;
    private boolean useSingleFile = false;
    private boolean compressResults = false;
    private boolean splitOutFiles = false;
    private long maxOutFileSize = 10000000L;
    private boolean openFolderOnFinish = true;
    private boolean executeProcessOnFinish = false;
    private String finishProcessCommand = null;

    public LobExtractType getLobExtractType() {
        return this.lobExtractType;
    }

    public void setLobExtractType(LobExtractType lobExtractType) {
        this.lobExtractType = lobExtractType;
    }

    public LobEncoding getLobEncoding() {
        return this.lobEncoding;
    }

    public void setLobEncoding(LobEncoding lobEncoding) {
        this.lobEncoding = lobEncoding;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isOutputEncodingBOM() {
        return this.outputEncodingBOM;
    }

    public void setOutputEncodingBOM(boolean outputEncodingBOM) {
        this.outputEncodingBOM = outputEncodingBOM;
    }

    public boolean isOutputClipboard() {
        return this.outputClipboard;
    }

    public void setOutputClipboard(boolean outputClipboard) {
        this.outputClipboard = outputClipboard;
    }

    public boolean isUseSingleFile() {
        return this.useSingleFile;
    }

    public void setUseSingleFile(boolean useSingleFile) {
        this.useSingleFile = useSingleFile;
    }

    public boolean isCompressResults() {
        return this.compressResults;
    }

    public void setCompressResults(boolean compressResults) {
        this.compressResults = compressResults;
    }

    public boolean isSplitOutFiles() {
        return this.splitOutFiles;
    }

    public void setSplitOutFiles(boolean splitOutFiles) {
        this.splitOutFiles = splitOutFiles;
    }

    public long getMaxOutFileSize() {
        return this.maxOutFileSize;
    }

    public void setMaxOutFileSize(long maxOutFileSize) {
        this.maxOutFileSize = maxOutFileSize;
    }

    public boolean isOpenFolderOnFinish() {
        return this.openFolderOnFinish;
    }

    public void setOpenFolderOnFinish(boolean openFolderOnFinish) {
        this.openFolderOnFinish = openFolderOnFinish;
    }

    public boolean isExecuteProcessOnFinish() {
        return this.executeProcessOnFinish;
    }

    public void setExecuteProcessOnFinish(boolean executeProcessOnFinish) {
        this.executeProcessOnFinish = executeProcessOnFinish;
    }

    public String getFinishProcessCommand() {
        return this.finishProcessCommand;
    }

    public void setFinishProcessCommand(String finishProcessCommand) {
        this.finishProcessCommand = finishProcessCommand;
    }

    public DBDDataFormatterProfile getFormatterProfile() {
        return this.formatterProfile;
    }

    public void setFormatterProfile(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.lobExtractType = (LobExtractType)CommonUtils.valueOf(LobExtractType.class, (String)((String)settings.get("lobExtractType")), (Enum)LobExtractType.SKIP);
        this.lobEncoding = (LobEncoding)CommonUtils.valueOf(LobEncoding.class, (String)((String)settings.get("lobEncoding")), (Enum)LobEncoding.HEX);
        this.outputFolder = CommonUtils.toString((Object)settings.get("outputFolder"), (String)this.outputFolder);
        this.outputFilePattern = CommonUtils.toString((Object)settings.get("outputFilePattern"), (String)this.outputFilePattern);
        this.outputEncoding = CommonUtils.toString((Object)settings.get("outputEncoding"), (String)this.outputEncoding);
        this.outputEncodingBOM = CommonUtils.getBoolean((Object)settings.get("outputEncodingBOM"), (boolean)this.outputEncodingBOM);
        this.outputClipboard = CommonUtils.getBoolean((Object)settings.get("outputClipboard"), (boolean)this.outputClipboard);
        this.useSingleFile = dataTransferSettings.getDataPipes().size() > 1 ? CommonUtils.getBoolean((Object)settings.get("useSingleFile"), (boolean)this.useSingleFile) : false;
        this.compressResults = CommonUtils.getBoolean((Object)settings.get("compressResults"), (boolean)this.compressResults);
        this.splitOutFiles = CommonUtils.getBoolean((Object)settings.get("splitOutFiles"), (boolean)this.splitOutFiles);
        this.maxOutFileSize = CommonUtils.toLong((Object)settings.get("maxOutFileSize"), (long)this.maxOutFileSize);
        this.openFolderOnFinish = CommonUtils.getBoolean((Object)settings.get("openFolderOnFinish"), (boolean)this.openFolderOnFinish);
        this.executeProcessOnFinish = CommonUtils.getBoolean((Object)settings.get("executeProcessOnFinish"), (boolean)this.executeProcessOnFinish);
        this.finishProcessCommand = CommonUtils.toString((Object)settings.get("finishProcessCommand"), (String)this.finishProcessCommand);
        String formatterProfile = CommonUtils.toString((Object)settings.get("formatterProfile"));
        if (!CommonUtils.isEmpty((String)formatterProfile)) {
            this.formatterProfile = DBWorkbench.getPlatform().getDataFormatterRegistry().getCustomProfile(formatterProfile);
        }
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        settings.put("lobExtractType", this.lobExtractType.name());
        settings.put("lobEncoding", this.lobEncoding.name());
        settings.put("outputFolder", this.outputFolder);
        settings.put("outputFilePattern", this.outputFilePattern);
        settings.put("outputEncoding", this.outputEncoding);
        settings.put("outputEncodingBOM", this.outputEncodingBOM);
        settings.put("outputClipboard", this.outputClipboard);
        settings.put("useSingleFile", this.useSingleFile);
        settings.put("compressResults", this.compressResults);
        settings.put("splitOutFiles", this.splitOutFiles);
        settings.put("maxOutFileSize", this.maxOutFileSize);
        settings.put("openFolderOnFinish", this.openFolderOnFinish);
        settings.put("executeProcessOnFinish", this.executeProcessOnFinish);
        settings.put("finishProcessCommand", this.finishProcessCommand);
        if (this.formatterProfile != null) {
            settings.put("formatterProfile", this.formatterProfile.getProfileName());
        } else {
            settings.put("formatterProfile", "");
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        if (!this.outputClipboard) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_use_single_file, this.useSingleFile);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_directory, this.outputFolder);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_file_name_pattern, this.outputFilePattern);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_encoding, this.outputEncoding);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_insert_bom, this.outputEncodingBOM);
        } else {
            DTUtils.addSummary(summary, "Copy to clipboard", this.outputClipboard);
        }
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_compress, this.compressResults);
        if (this.executeProcessOnFinish) {
            DTUtils.addSummary(summary, "Execute process on finish", this.finishProcessCommand);
        }
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_binaries, (Object)this.lobExtractType);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_encoding, (Object)this.lobEncoding);
        if (this.formatterProfile != null) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_formatting, this.formatterProfile.getProfileName());
        }
        return summary.toString();
    }

    public static enum LobEncoding {
        BASE64,
        HEX,
        BINARY,
        NATIVE;

    }

    public static enum LobExtractType {
        SKIP,
        FILES,
        INLINE;

    }
}

