/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskCategoryDescriptor;
import org.jkiss.dbeaver.registry.task.TaskConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;

public class TaskRegistry
implements DBTTaskRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.task";
    private static final Log log = Log.getLog(TaskRegistry.class);
    private static TaskRegistry instance = null;
    private final Map<String, TaskCategoryDescriptor> taskCategories = new LinkedHashMap<String, TaskCategoryDescriptor>();
    private final Map<String, TaskTypeDescriptor> taskDescriptors = new LinkedHashMap<String, TaskTypeDescriptor>();
    private final List<DBTTaskListener> taskListeners = new ArrayList<DBTTaskListener>();

    public static synchronized TaskRegistry getInstance() {
        if (instance == null) {
            instance = new TaskRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private TaskRegistry(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("category".equals(ext.getName())) {
                TaskCategoryDescriptor descriptor = new TaskCategoryDescriptor(this, ext);
                this.taskCategories.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            TaskCategoryDescriptor taskType;
            String typeId;
            ext = iConfigurationElementArray[n2];
            if ("task".equals(ext.getName())) {
                typeId = ext.getAttribute("type");
                taskType = this.getTaskCategory(typeId);
                TaskTypeDescriptor taskDescriptor = new TaskTypeDescriptor(taskType, ext);
                this.taskDescriptors.put(taskDescriptor.getId(), taskDescriptor);
            } else if ("configurator".equals(ext.getName())) {
                typeId = ext.getAttribute("type");
                taskType = this.getTaskCategory(typeId);
                if (taskType == null) {
                    log.debug((Object)"");
                } else {
                    TaskConfiguratorDescriptor configDescriptor = new TaskConfiguratorDescriptor(taskType, ext);
                    taskType.setConfigurator(configDescriptor);
                }
            }
            ++n2;
        }
    }

    @NotNull
    public DBTTaskType[] getAllTaskTypes() {
        return this.taskDescriptors.values().toArray(new DBTTaskType[0]);
    }

    @Nullable
    public DBTTaskType getTaskType(String id) {
        return this.taskDescriptors.get(id);
    }

    @NotNull
    public DBTTaskCategory[] getAllCategories() {
        return this.taskCategories.values().toArray(new DBTTaskCategory[0]);
    }

    @NotNull
    public DBTTaskCategory[] getRootCategories() {
        ArrayList<TaskCategoryDescriptor> result = new ArrayList<TaskCategoryDescriptor>();
        for (TaskCategoryDescriptor cat : this.taskCategories.values()) {
            if (cat.getParent() != null) continue;
            result.add(cat);
        }
        return result.toArray(new DBTTaskCategory[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(DBTTaskListener listener) {
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(DBTTaskListener listener) {
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            if (!this.taskListeners.remove(listener)) {
                log.debug((Object)("Task listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTaskListeners(DBTTaskEvent event) {
        DBTTaskListener[] listenersCopy;
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            listenersCopy = this.taskListeners.toArray(new DBTTaskListener[0]);
        }
        DBTTaskListener[] dBTTaskListenerArray = listenersCopy;
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskListener listener = dBTTaskListenerArray[n2];
            listener.handleTaskEvent(event);
            ++n2;
        }
    }

    @Nullable
    TaskCategoryDescriptor getTaskCategory(String id) {
        return this.taskCategories.get(id);
    }
}

