/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLHyperlinkDetector;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigateObjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IHyperlink hyperlink;
        SQLEditorBase sqlEditor;
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor != null && (sqlEditor = (SQLEditorBase)((Object)DBUtils.getAdapter(SQLEditorBase.class, (Object)activeEditor))) != null && (hyperlink = this.getCurrentHyperlink(sqlEditor)) != null) {
            IRegion selRegion2 = hyperlink.getHyperlinkRegion();
            TextViewer textViewer = sqlEditor.getTextViewer();
            if (textViewer != null) {
                textViewer.setSelectedRange(selRegion2.getOffset(), selRegion2.getLength());
            }
            hyperlink.open();
        }
        return null;
    }

    private IHyperlink getCurrentHyperlink(SQLEditorBase editor) {
        SQLHyperlinkDetector hyperlinkDetector = new SQLHyperlinkDetector(editor, editor.getSyntaxManager());
        ITextSelection selection = (ITextSelection)editor.getTextViewer().getSelection();
        Region curRegion = new Region(selection.getOffset(), 0);
        Object[] hyperLinks = hyperlinkDetector.detectHyperlinks((ITextViewer)editor.getTextViewer(), (IRegion)curRegion, false);
        if (!ArrayUtils.isEmpty((Object[])hyperLinks)) {
            return hyperLinks[0];
        }
        String lastKeyword = hyperlinkDetector.getLastKeyword();
        if (!CommonUtils.isEmpty((String)lastKeyword)) {
            IEditorStatusLine statusLine = editor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, "Can't find metadata object for name '" + lastKeyword + "'", null);
            }
            editor.getEditorControl().getDisplay().beep();
        }
        return null;
    }
}

