/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLObjectResolver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;
import org.jkiss.utils.CommonUtils;

public class SQLEntityResolver
extends SQLObjectResolver<DBSEntity> {
    public SQLEntityResolver() {
        super("table", "Database table");
    }

    @Override
    protected void resolveObjects(DBRProgressMonitor monitor, DBCExecutionContext executionContext, TemplateContext context, List<DBSEntity> entities) throws DBException {
        SQLEntityResolver.resolveTables(monitor, executionContext, context, entities);
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        super.resolve(variable, context);
        if (variable instanceof SQLVariable) {
            ((SQLVariable)variable).setResolver(this);
        }
    }

    static void resolveTables(DBRProgressMonitor monitor, DBCExecutionContext executionContext, TemplateContext context, List<DBSEntity> entities) throws DBException {
        SQLVariable schemaVariable = ((SQLContext)context).getTemplateVariable("schema");
        SQLVariable catalogVariable = ((SQLContext)context).getTemplateVariable("catalog");
        String catalogName = catalogVariable == null ? null : catalogVariable.getDefaultValue();
        String schemaName = schemaVariable == null ? null : schemaVariable.getDefaultValue();
        DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)executionContext.getDataSource());
        if (objectContainer == null) {
            return;
        }
        if (!CommonUtils.isEmpty((String)catalogName) || !CommonUtils.isEmpty((String)schemaName)) {
            objectContainer = (DBSObjectContainer)DBUtils.getObjectByPath((DBRProgressMonitor)monitor, (DBSObjectContainer)objectContainer, (String)catalogName, (String)schemaName, null);
        } else {
            DBSObjectSelector objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)executionContext.getDataSource());
            if (objectSelector != null) {
                objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)objectSelector.getDefaultObject());
            }
        }
        if (objectContainer != null) {
            SQLEntityResolver.makeProposalsFromChildren(monitor, objectContainer, entities);
        }
    }

    static void makeProposalsFromChildren(DBRProgressMonitor monitor, DBSObjectContainer container, List<DBSEntity> names) throws DBException {
        Collection children = container.getChildren(monitor);
        if (CommonUtils.isEmpty((Collection)children)) {
            return;
        }
        for (DBSObject child : children) {
            if (!(child instanceof DBSEntity)) continue;
            names.add((DBSEntity)child);
        }
    }
}

