/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public abstract class SQLServerBaseTableManager<OBJECT extends SQLServerTableBase>
extends SQLTableManager<OBJECT, SQLServerSchema>
implements DBEObjectRenamer<OBJECT> {
    public DBSObjectCache<SQLServerSchema, OBJECT> getObjectsCache(OBJECT object) {
        return ((SQLServerTableBase)object).getSchema().getTableCache();
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.NestedObjectCommand<OBJECT, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        SQLServerTableBase table = (SQLServerTableBase)command.getObject();
        if (command.getProperty((Object)"description") != null) {
            boolean isUpdate = SQLServerUtils.isCommentSet(monitor, table.getDatabase(), SQLServerObjectClass.OBJECT_OR_COLUMN, table.getObjectId(), 0L);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Add table comment", "EXEC " + SQLServerUtils.getSystemTableName(table.getDatabase(), isUpdate ? "sp_updateextendedproperty" : "sp_addextendedproperty") + " 'MS_Description', " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((SQLServerTableBase)command.getObject()).getDescription()) + "," + " 'schema', '" + table.getSchema().getName() + "'," + " '" + (table.isView() ? "view" : "table") + "', '" + table.getName() + "'"));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        SQLServerTableBase object = (SQLServerTableBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "EXEC " + SQLServerUtils.getSystemTableName(object.getDatabase(), "sp_rename") + " '" + object.getSchema().getFullyQualifiedName(DBPEvaluationContext.DML) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)command.getOldName()) + "' , '" + DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)command.getNewName()) + "', 'OBJECT'"));
    }
}

