/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private final StyledText filtersText;

    public StyledTextContentAdapter(StyledText filtersText) {
        this.filtersText = filtersText;
    }

    public String getControlContents(Control control) {
        return this.filtersText.getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        this.filtersText.setText(text);
        this.filtersText.setSelection(cursorPosition, cursorPosition);
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        Point selection = this.filtersText.getSelection();
        this.filtersText.insert(text);
        if (cursorPosition <= text.length()) {
            this.filtersText.setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }

    public int getCursorPosition(Control control) {
        return this.filtersText.getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        Point caretOrigin = this.filtersText.getLocationAtOffset(this.filtersText.getCaretOffset());
        return new Rectangle(caretOrigin.x + this.filtersText.getClientArea().x, caretOrigin.y + this.filtersText.getClientArea().y + 3, 1, this.filtersText.getLineHeight());
    }

    public void setCursorPosition(Control control, int position) {
        this.filtersText.setSelection(new Point(position, position));
    }

    public Point getSelection(Control control) {
        return this.filtersText.getSelection();
    }

    public void setSelection(Control control, Point range) {
        this.filtersText.setSelection(range);
    }
}

