/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.part.ResourceTransfer;

class CopyToClipboardAction
extends SelectionListenerAction {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final String ID = "org.eclipse.team.ui.synchronize.action.copy";
    private final Shell fShell;
    private final Clipboard fClipboard;
    private final INavigatorContentService navigatorContentService;

    protected CopyToClipboardAction(Shell shell, INavigatorContentService navigatorContentService) {
        super(TeamUIMessages.CopyToClipboardAction_1);
        this.navigatorContentService = navigatorContentService;
        Assert.isNotNull((Object)shell);
        this.fShell = shell;
        this.fClipboard = new Clipboard(shell.getDisplay());
        this.setToolTipText(TeamUIMessages.CopyToClipboardAction_2);
        this.setId(ID);
    }

    public void run() {
        this.copyResources(this.getSelectedResources(), this.getTextualClipboardContents());
    }

    private String getTextualClipboardContents() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (structuredSelection instanceof TreeSelection) {
            TreePath[] paths;
            TreeSelection ts = (TreeSelection)structuredSelection;
            TreePath[] treePathArray = paths = ts.getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                String text = this.getTextFor(path);
                if (text != null && text.length() > 0) {
                    if (i > 0) {
                        buf.append(EOL);
                    }
                    buf.append(text);
                    ++i;
                }
                ++n2;
            }
        } else {
            for (Object element : structuredSelection) {
                if (element instanceof ITypedElement) {
                    if (i > 0) {
                        buf.append(EOL);
                    }
                    buf.append(((ITypedElement)element).getName());
                    ++i;
                    continue;
                }
                IResource resource = Utils.getResource(element);
                if (resource == null) continue;
                if (i > 0) {
                    buf.append(EOL);
                }
                buf.append(resource.getName());
                ++i;
            }
        }
        return buf.toString();
    }

    private String getTextFor(TreePath path) {
        Object element = path.getLastSegment();
        if (element instanceof ITypedElement) {
            return ((ITypedElement)element).getName();
        }
        INavigatorContentService service = this.getNavigatorContentService();
        if (service != null) {
            ILabelProvider provider = service.createCommonLabelProvider();
            if (provider instanceof ITreePathLabelProvider) {
                ITreePathLabelProvider tplp = (ITreePathLabelProvider)provider;
                ViewerLabel viewerLabel = new ViewerLabel("", null);
                tplp.updateLabel(viewerLabel, path);
                return viewerLabel.getText();
            }
            return provider.getText(element);
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getName();
        }
        return null;
    }

    private INavigatorContentService getNavigatorContentService() {
        return this.navigatorContentService;
    }

    private void copyResources(List<? extends IResource> selectedResources, String text) {
        IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            ++i;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i2 = 0;
            while (i2 < actualLength) {
                fileNames[i2] = tempFileNames[i2];
                ++i2;
            }
        }
        this.setClipboard(resources, fileNames, text);
    }

    private void setClipboard(IResource[] resources, String[] fileNames, String names) {
        block7: {
            try {
                ArrayList<Object> data = new ArrayList<Object>();
                ArrayList<Object> dataTypes = new ArrayList<Object>();
                if (resources.length > 0) {
                    data.add(resources);
                    dataTypes.add(ResourceTransfer.getInstance());
                }
                if (fileNames.length > 0) {
                    data.add(fileNames);
                    dataTypes.add(FileTransfer.getInstance());
                }
                if (names != null && names.length() > 0) {
                    data.add(names);
                    dataTypes.add(TextTransfer.getInstance());
                }
                if (!data.isEmpty()) {
                    this.fClipboard.setContents(data.toArray(), dataTypes.toArray(new Transfer[dataTypes.size()]));
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fShell, (String)TeamUIMessages.CopyToClipboardAction_3, (String)TeamUIMessages.CopyToClipboardAction_4)) break block7;
                this.setClipboard(resources, fileNames, names);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        List<? extends IResource> selectedResources = this.getSelectedResources();
        List<?> selectedNonResources = this.getSelectedNonResources();
        if (selectedResources.size() > 0 && selectedNonResources.isEmpty()) {
            boolean projSelected = this.selectionIsOfType(4);
            boolean fileFoldersSelected = this.selectionIsOfType(3);
            if (!projSelected && !fileFoldersSelected) {
                return false;
            }
            if (projSelected && fileFoldersSelected) {
                return false;
            }
            IContainer firstParent = selectedResources.get(0).getParent();
            if (firstParent == null) {
                return false;
            }
            for (IResource iResource : selectedResources) {
                if (!iResource.getParent().equals((Object)firstParent)) {
                    return false;
                }
                if (iResource.getLocation() != null) continue;
                return false;
            }
            return true;
        }
        return selectedNonResources.size() > 0 && selectedResources.isEmpty();
    }

    protected List<?> getSelectedNonResources() {
        return Arrays.asList(Utils.getNonResources(this.getStructuredSelection().toArray()));
    }

    protected List<? extends IResource> getSelectedResources() {
        return Arrays.asList(Utils.getResources(this.getStructuredSelection().toArray()));
    }

    public void dispose() {
        this.fClipboard.dispose();
    }
}

