/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class SQLSelectItem {
    private SelectItem source;
    private Table table;
    private String name;
    private boolean plainColumn;

    SQLSelectItem(SelectItem item) {
        this.source = item;
        if (item instanceof SelectExpressionItem) {
            Expression itemExpression = ((SelectExpressionItem)item).getExpression();
            if (itemExpression instanceof Column) {
                this.table = ((Column)itemExpression).getTable();
                this.name = ((Column)itemExpression).getColumnName();
                this.plainColumn = true;
            } else {
                this.table = null;
                Alias alias = ((SelectExpressionItem)item).getAlias();
                this.name = alias != null ? alias.getName() : item.toString();
            }
        } else if (item instanceof AllColumns) {
            this.table = null;
            this.name = "*";
        } else if (item instanceof AllTableColumns) {
            this.table = ((AllTableColumns)item).getTable();
            this.name = "*";
        } else {
            this.table = null;
            this.name = "?";
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlainColumn() {
        return this.plainColumn;
    }

    public String toString() {
        return this.source.toString();
    }
}

