/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.runtime.ServiceRegistry;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.console.ConsoleUserInterface;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBWorkbench {
    private static final Log log = Log.getLog(DBWorkbench.class);
    private static final DBWorkbench instance = new DBWorkbench();
    private static volatile DBPPlatform platformInstance = null;
    private static volatile DBPPlatformUI platformUIInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBPPlatform getPlatform() {
        if (platformInstance != null) return platformInstance;
        Class<DBWorkbench> clazz = DBWorkbench.class;
        synchronized (DBWorkbench.class) {
            if (platformInstance != null || (platformInstance = GeneralUtils.adapt(instance, DBPPlatform.class)) != null) return platformInstance;
            throw new IllegalStateException("Internal configuration error. Platform not instantiated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBPPlatformUI getPlatformUI() {
        if (platformUIInstance != null) return platformUIInstance;
        Class<DBWorkbench> clazz = DBWorkbench.class;
        synchronized (DBWorkbench.class) {
            if (platformUIInstance != null || (platformUIInstance = GeneralUtils.adapt(instance, DBPPlatformUI.class)) != null) return platformUIInstance;
            log.debug("No platform UI installed. Use console interface.");
            platformUIInstance = new ConsoleUserInterface();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platformUIInstance;
        }
    }

    @Nullable
    public static <T> T getService(@NotNull Class<T> serviceType) {
        T service = ServiceRegistry.getInstance().getService(serviceType);
        if (service == null) {
            log.error("Service '" + serviceType.getName() + "' not found");
        }
        return service;
    }
}

