/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.storage.BytesContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;

public abstract class DBDDocumentContentProxy
implements DBDDocument {
    @NotNull
    protected final DBDContent content;
    protected final DBDDocument document;

    protected DBDDocumentContentProxy(@NotNull DBDContent content) throws DBException {
        this.content = content;
        this.document = this.createDocumentFromContent(content);
    }

    @NotNull
    protected abstract DBDDocument createDocumentFromContent(@NotNull DBDContent var1) throws DBException;

    @Override
    @Nullable
    public Object getDocumentProperty(String name) {
        return this.document.getDocumentProperty(name);
    }

    @Override
    @NotNull
    public String getDocumentContentType() {
        return this.document.getDocumentContentType();
    }

    @Override
    @NotNull
    public Object getRootNode() {
        return this.document.getRootNode();
    }

    @Override
    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException {
        DBDContentStorage contents = this.content.getContents(monitor);
        if (contents != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream contentStream = contents.getContentStream();){
                    ContentUtils.copyStreams(contentStream, this.content.getContentLength(), stream, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("Error copying content stream", e);
            }
        }
    }

    @Override
    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ContentUtils.copyStreams(stream, -1L, baos, monitor);
            this.content.updateContents(monitor, new BytesContentStorage(baos.toByteArray(), charset));
            this.document.updateDocument(monitor, new ByteArrayInputStream(baos.toByteArray()), charset);
        }
        catch (IOException e) {
            throw new DBException("Error transforming XML document", e);
        }
    }

    @Override
    public Object getRawValue() {
        return this.document.getRawValue();
    }

    @Override
    public boolean isNull() {
        return this.document.isNull();
    }

    @Override
    public boolean isModified() {
        return this.document.isModified();
    }

    @Override
    public void release() {
        this.document.release();
    }
}

