/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class EditTaskConfigurationDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.EditTaskConfigurationDialog";
    private TaskImpl task;
    private final DBPProject project;
    private DBTTaskType taskType;
    private Map<String, Object> state;
    private Combo taskLabelCombo;
    private Text taskDescriptionText;
    private DBTTask[] allTasks;

    public EditTaskConfigurationDialog(Shell parentShell, @NotNull DBTTask task) {
        super(parentShell, "Edit task [" + task.getName() + "]", (DBPImage)(task.getType().getIcon() == null ? DBIcon.TREE_TASK : task.getType().getIcon()));
        this.task = (TaskImpl)task;
        this.project = task.getProject();
        this.taskType = task.getType();
        this.state = task.getProperties();
    }

    public EditTaskConfigurationDialog(Shell parentShell, @NotNull DBPProject project, @NotNull DBTTaskType taskType) {
        super(parentShell, "Create task", (DBPImage)DBIcon.TREE_TASK);
        this.task = null;
        this.project = project;
        this.taskType = taskType;
        this.state = new LinkedHashMap<String, Object>();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        Composite formPanel = UIUtils.createComposite((Composite)composite, (int)2);
        formPanel.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = e -> this.updateButtons();
        UIUtils.createLabelText((Composite)formPanel, (String)"Type", (String)(String.valueOf(this.taskType.getCategory().getName()) + " / " + this.taskType.getName()), (int)2056);
        this.taskLabelCombo = UIUtils.createLabelCombo((Composite)formPanel, (String)"Name", (String)"", (int)2048);
        ((GridData)this.taskLabelCombo.getLayoutData()).widthHint = 300;
        if (this.task != null) {
            this.taskLabelCombo.setText(this.task.getName());
        } else {
            this.taskLabelCombo.add("");
            DBTTaskManager taskManager = this.project.getTaskManager();
            DBTTask[] dBTTaskArray = this.allTasks = taskManager.getAllTaskByType(this.taskType);
            int n = this.allTasks.length;
            int n2 = 0;
            while (n2 < n) {
                DBTTask tc = dBTTaskArray[n2];
                this.taskLabelCombo.add(tc.getName());
                ++n2;
            }
            this.taskLabelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = EditTaskConfigurationDialog.this.taskLabelCombo.getSelectionIndex();
                    if (selectionIndex == 0) {
                        EditTaskConfigurationDialog.this.task = null;
                        EditTaskConfigurationDialog.this.setTitle("Create task " + EditTaskConfigurationDialog.this.taskType.getName());
                    } else {
                        EditTaskConfigurationDialog.this.task = (TaskImpl)EditTaskConfigurationDialog.this.allTasks[selectionIndex - 1];
                        EditTaskConfigurationDialog.this.taskDescriptionText.setText(CommonUtils.notEmpty((String)EditTaskConfigurationDialog.this.task.getDescription()));
                        EditTaskConfigurationDialog.this.setTitle("Edit task " + EditTaskConfigurationDialog.this.task.getName());
                    }
                }
            });
        }
        this.taskLabelCombo.addModifyListener(modifyListener);
        this.taskDescriptionText = UIUtils.createLabelText((Composite)formPanel, (String)"Description", (String)(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getDescription())), (int)2562);
        ((GridData)this.taskDescriptionText.getLayoutData()).heightHint = this.taskDescriptionText.getLineHeight() * 5;
        this.taskDescriptionText.addModifyListener(modifyListener);
        UIUtils.asyncExec(() -> {
            boolean bl = this.taskLabelCombo.setFocus();
        });
        return composite;
    }

    private boolean isTaskEditor() {
        return this.task != null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isReady = !this.taskLabelCombo.getText().isEmpty();
        this.getButton(0).setEnabled(isReady);
    }

    protected void okPressed() {
        DBTTaskManager taskManager = this.project.getTaskManager();
        try {
            if (this.task == null) {
                this.task = (TaskImpl)taskManager.createTaskConfiguration(this.taskType, this.taskLabelCombo.getText(), this.taskDescriptionText.getText(), this.state);
            }
            this.task.setName(this.taskLabelCombo.getText());
            this.task.setDescription(this.taskDescriptionText.getText());
            this.task.setUpdateTime(new Date());
            this.task.setProperties(this.state);
            taskManager.updateTaskConfiguration((DBTTask)this.task);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Create task", "Error creating data transfer task", (Throwable)e);
        }
        super.okPressed();
    }

    public DBTTask getTask() {
        return this.task;
    }
}

