/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.utils.CommonUtils;

public class GenericSQLDialect
extends JDBCSQLDialect {
    private static String[] EXEC_KEYWORDS = new String[]{"EXEC", "CALL"};
    private String scriptDelimiter;
    private char stringEscapeCharacter = '\u0000';
    private String scriptDelimiterRedefiner;
    private boolean legacySQLDialect;
    private boolean suportsUpsert;
    private boolean quoteReservedWords;
    private boolean useSearchStringEscape;
    private String dualTable;
    private String testSQL;
    private boolean hasDelimiterAfterQuery;
    private boolean hasDelimiterAfterBlock;
    private boolean callableQueryInBrackets;

    public GenericSQLDialect() {
        super("Generic");
    }

    protected GenericSQLDialect(String name) {
        super(name);
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        DBPDriver driver = dataSource.getContainer().getDriver();
        this.scriptDelimiter = CommonUtils.toString((Object)driver.getDriverParameter("script-delimiter"));
        String escapeStr = CommonUtils.toString((Object)driver.getDriverParameter("string-escape-char"));
        if (!CommonUtils.isEmpty((String)escapeStr)) {
            this.stringEscapeCharacter = escapeStr.charAt(0);
        }
        this.scriptDelimiterRedefiner = CommonUtils.toString((Object)driver.getDriverParameter("script-delimiter-redefiner"));
        this.hasDelimiterAfterQuery = CommonUtils.toBoolean((Object)driver.getDriverParameter("script-delimiter-after-query"));
        this.hasDelimiterAfterBlock = CommonUtils.toBoolean((Object)driver.getDriverParameter("script-delimiter-after-block"));
        this.legacySQLDialect = CommonUtils.toBoolean((Object)driver.getDriverParameter("legacy-sql-dialect"));
        this.suportsUpsert = ((GenericDataSource)dataSource).getMetaModel().supportsUpsertStatement();
        if (this.suportsUpsert) {
            this.addSQLKeyword("UPSERT");
        }
        this.useSearchStringEscape = CommonUtils.getBoolean((Object)driver.getDriverParameter("use-search-string-escape"), (boolean)false);
        this.quoteReservedWords = CommonUtils.getBoolean((Object)driver.getDriverParameter("quote-reserved-words"), (boolean)true);
        this.testSQL = CommonUtils.toString((Object)driver.getDriverParameter("ping-sql"));
        if (CommonUtils.isEmpty((String)this.testSQL)) {
            this.testSQL = CommonUtils.toString((Object)driver.getDriverParameter("query-get-active-db"));
        }
        this.dualTable = CommonUtils.toString((Object)driver.getDriverParameter("dual-table"));
        if (this.dualTable.isEmpty()) {
            this.dualTable = null;
        }
    }

    @NotNull
    public String getScriptDelimiter() {
        return CommonUtils.isEmpty((String)this.scriptDelimiter) ? super.getScriptDelimiter() : this.scriptDelimiter;
    }

    public char getStringEscapeCharacter() {
        return this.stringEscapeCharacter;
    }

    public String getScriptDelimiterRedefiner() {
        return this.scriptDelimiterRedefiner;
    }

    public boolean supportsAliasInSelect() {
        return super.supportsAliasInSelect();
    }

    public boolean isDelimiterAfterQuery() {
        return this.hasDelimiterAfterQuery;
    }

    public boolean isDelimiterAfterBlock() {
        return this.hasDelimiterAfterBlock;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public boolean isLegacySQLDialect() {
        return this.legacySQLDialect;
    }

    public boolean supportsUpsertStatement() {
        return this.suportsUpsert;
    }

    public boolean isQuoteReservedWords() {
        return this.quoteReservedWords;
    }

    public String formatStoredProcedureCall(DBPDataSource dataSource, String sqlText) {
        if (this.callableQueryInBrackets) {
            return "{" + sqlText + "}";
        }
        return super.formatStoredProcedureCall(dataSource, sqlText);
    }

    public String getTestSQL() {
        return this.testSQL;
    }

    @Nullable
    public String getDualTableName() {
        return this.dualTable;
    }

    @NotNull
    public String getSearchStringEscape() {
        if (this.useSearchStringEscape) {
            return super.getSearchStringEscape();
        }
        return null;
    }
}

