/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.CommonUtils;

public class GenericStructureAssistant
extends JDBCStructureAssistant {
    private final GenericDataSource dataSource;

    GenericStructureAssistant(GenericDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected GenericDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    protected void findObjectsByMask(JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> references) throws DBException, SQLException {
        GenericSchema schema;
        GenericSchema genericSchema = schema = parentObject instanceof GenericSchema ? (GenericSchema)parentObject : null;
        GenericCatalog catalog = parentObject instanceof GenericCatalog ? (GenericCatalog)parentObject : (schema == null ? null : schema.getCatalog());
        GenericDataSource dataSource = this.getDataSource();
        DBPIdentifierCase convertCase = caseSensitive ? dataSource.getSQLDialect().storesQuotedCase() : dataSource.getSQLDialect().storesUnquotedCase();
        objectNameMask = convertCase.transform(objectNameMask);
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, catalog, schema, objectNameMask, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, catalog, schema, objectNameMask, maxResults, references);
        }
    }

    private void findTablesByMask(JDBCSession session, GenericCatalog catalog, GenericSchema schema, String tableNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        GenericMetaObject tableObject = this.getDataSource().getMetaObject("table");
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCResultSet dbResult = session.getMetaData().getTables(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), tableNameMask, null);){
            while (dbResult.next()) {
                if (monitor.isCanceled()) {
                } else {
                    String catalogName = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_CAT");
                    String schemaName = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_SCHEM");
                    String tableName = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_NAME");
                    if (CommonUtils.isEmpty((String)tableName)) continue;
                    objects.add((DBSObjectReference)new TableReference(this.findContainer(session.getProgressMonitor(), catalog, schema, catalogName, schemaName), tableName, GenericUtils.safeGetString(tableObject, (ResultSet)dbResult, "REMARKS")));
                    if (objects.size() < maxResults) continue;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, GenericCatalog catalog, GenericSchema schema, String procNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        GenericMetaObject procObject = this.getDataSource().getMetaObject("procedure");
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCResultSet dbResult = session.getMetaData().getProcedures(catalog == null ? null : catalog.getName(), schema == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)schema.getName()), procNameMask);){
            while (dbResult.next()) {
                if (monitor.isCanceled()) {
                } else {
                    String catalogName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_CAT");
                    String schemaName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_SCHEM");
                    String procName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_NAME");
                    String uniqueName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "SPECIFIC_NAME");
                    if (CommonUtils.isEmpty((String)procName)) continue;
                    if (CommonUtils.isEmpty((String)uniqueName)) {
                        uniqueName = procName;
                    }
                    procName = GenericUtils.normalizeProcedureName(procName);
                    objects.add((DBSObjectReference)new ProcedureReference(this.findContainer(session.getProgressMonitor(), catalog, schema, catalogName, schemaName), catalogName, procName, uniqueName));
                    if (objects.size() < maxResults) continue;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private GenericStructContainer findContainer(DBRProgressMonitor monitor, GenericCatalog parentCatalog, GenericSchema parentSchema, String catalogName, String schemaName) throws DBException {
        GenericSchema tableSchema;
        GenericCatalog tableCatalog;
        GenericCatalog genericCatalog = parentCatalog != null ? parentCatalog : (tableCatalog = CommonUtils.isEmpty((String)catalogName) ? null : this.dataSource.getCatalog(catalogName));
        if (tableCatalog == null && CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty(this.dataSource.getCatalogs()) && this.dataSource.getCatalogs().size() == 1) {
            tableCatalog = this.dataSource.getCatalogs().iterator().next();
        }
        Object object = parentSchema != null ? parentSchema : (CommonUtils.isEmpty((String)schemaName) ? null : (tableSchema = tableCatalog == null ? this.dataSource.getSchema(schemaName) : tableCatalog.getSchema(monitor, schemaName)));
        return tableSchema != null ? tableSchema : (tableCatalog != null ? tableCatalog : this.dataSource);
    }

    private abstract class ObjectReference
    extends AbstractObjectReference {
        ObjectReference(GenericStructContainer container, String name, String description, Class<?> objectClass, DBSObjectType type) {
            super(name, (DBSObject)container, description, objectClass, type);
        }

        public GenericStructContainer getContainer() {
            return (GenericStructContainer)super.getContainer();
        }
    }

    private class ProcedureReference
    extends ObjectReference {
        private final String catalogName;
        private String uniqueName;

        private ProcedureReference(GenericStructContainer container, String catalogName, String procedureName, String uniqueName) {
            super(container, procedureName, null, GenericProcedure.class, RelationalObjectType.TYPE_PROCEDURE);
            this.catalogName = catalogName;
            this.uniqueName = uniqueName;
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            GenericPackage procPackage;
            GenericProcedure procedure = null;
            if (this.getContainer() instanceof GenericSchema && !CommonUtils.isEmpty((String)this.catalogName) && (procPackage = ((GenericSchema)this.getContainer()).getPackage(monitor, this.catalogName)) != null) {
                procedure = procPackage.getProcedure(monitor, this.uniqueName);
            }
            if (procedure == null) {
                procedure = this.getContainer().getProcedure(monitor, this.uniqueName);
            }
            if (procedure == null) {
                throw new DBException("Can't find procedure '" + this.getName() + "' (" + this.uniqueName + ")" + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)GenericStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
            }
            return procedure;
        }
    }

    private class TableReference
    extends ObjectReference {
        private TableReference(GenericStructContainer container, String tableName, String description) {
            super(container, tableName, description, GenericTable.class, RelationalObjectType.TYPE_TABLE);
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            GenericTableBase table = this.getContainer().getTable(monitor, this.getName());
            if (table == null) {
                throw new DBException("Can't find table '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)GenericStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
            }
            return table;
        }
    }
}

