/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

public class DataSourcePropertyTester
extends PropertyTester {
    protected static final Log log = Log.getLog(DataSourcePropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.datasource";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_TRANSACTIONAL = "transactional";
    public static final String PROP_SUPPORTS_TRANSACTIONS = "supportsTransactions";
    public static final String PROP_TRANSACTION_ACTIVE = "transactionActive";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            while (true) {
                if (!(receiver instanceof DBNDatabaseNode) || receiver instanceof DBNDataSource) {
                    if (receiver instanceof DBPContextProvider) break;
                    return false;
                }
                receiver = ((DBNDatabaseNode)receiver).getParentNode();
            }
            DBPContextProvider contextProvider = (DBPContextProvider)receiver;
            DBCExecutionContext context = contextProvider.getExecutionContext();
            switch (property) {
                case "connected": {
                    DBPDataSourceContainer container;
                    boolean isConnected = context != null ? context.getDataSource().getContainer().isConnected() : (receiver instanceof IDataSourceContainerProvider ? (container = ((IDataSourceContainerProvider)receiver).getDataSourceContainer()) != null && container.isConnected() : false);
                    boolean checkConnected = Boolean.TRUE.equals(expectedValue);
                    if (checkConnected) {
                        boolean bl = isConnected;
                        return bl;
                    }
                    if (!isConnected) return true;
                    return false;
                }
                case "transactional": {
                    if (context == null) {
                        return false;
                    }
                    if (!context.isConnected()) {
                        return Boolean.FALSE.equals(expectedValue);
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    try {
                        if (txnManager == null) return false;
                        if (!Boolean.valueOf(!txnManager.isAutoCommit()).equals(expectedValue)) return false;
                        return true;
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Error checking auto-commit state", (Throwable)e);
                        return false;
                    }
                }
                case "supportsTransactions": {
                    if (context == null) return false;
                    if (!context.isConnected()) {
                        return false;
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    if (txnManager == null) return false;
                    if (!txnManager.isEnabled()) return false;
                    return true;
                }
                case "transactionActive": {
                    if (context == null) return Boolean.FALSE.equals(expectedValue);
                    if (!context.isConnected()) return Boolean.FALSE.equals(expectedValue);
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    if (txnManager == null) return false;
                    if (txnManager.isAutoCommit()) return false;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            log.debug((Object)("Error testing property " + property + ": " + e.getMessage()));
            return false;
        }
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.datasource." + propName));
    }

    private static void updateEditorsDirtyFlag() {
        IEditorReference[] editors;
        IEditorReference[] iEditorReferenceArray = editors = UIUtils.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor instanceof SQLEditor) {
                UIUtils.asyncExec(() -> ((SQLEditor)((SQLEditor)editor)).updateDirtyFlag());
            }
            ++n2;
        }
    }

    private static class QMEventsHandler
    extends DefaultExecutionHandler {
        private QMEventsHandler() {
        }

        @NotNull
        public String getHandlerName() {
            return DataSourcePropertyTester.class.getName();
        }

        public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTIONAL);
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                ActionUtils.fireCommandRefresh((String)"org.jkiss.dbeaver.core.txn.autocommit");
            });
        }

        public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
            this.updateUI(() -> DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE));
        }

        private void updateUI(Runnable runnable) {
            UIUtils.asyncExec((Runnable)runnable);
        }
    }

    public static class QMService
    implements IPluginService {
        private QMEventsHandler qmHandler;

        public void activateService() {
            this.qmHandler = new QMEventsHandler();
            QMUtils.registerHandler((QMExecutionHandler)this.qmHandler);
        }

        public void deactivateService() {
            QMUtils.unregisterHandler((QMExecutionHandler)this.qmHandler);
        }
    }
}

