/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;

public class CreateConnectionDialog
extends ActiveWizardDialog {
    public static final int TEST_BUTTON_ID = 2000;
    private Button testButton;

    public CreateConnectionDialog(IWorkbenchWindow window, ConnectionWizard wizard) {
        super(window, (IWizard)wizard);
        this.setAdaptContainerSizeToPages(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.testButton = this.createButton(parent, 2000, CoreMessages.dialog_connection_button_test, false);
        this.testButton.setEnabled(false);
        this.testButton.moveAbove((Control)this.getButton(14));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.testConnection();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        ConnectionWizard wizard = (ConnectionWizard)this.getWizard();
        ConnectionPageSettings settings = wizard.getPageSettings();
        this.testButton.setEnabled(settings != null && settings.isPageComplete());
        super.updateButtons();
    }

    private void testConnection() {
        ConnectionWizard wizard = (ConnectionWizard)this.getWizard();
        wizard.testConnection();
    }

    public int open() {
        if (DBWorkbench.getPlatform().getWorkspace().getActiveProject() == null) {
            DBWorkbench.getPlatformUI().showError("No active project", "No active project, can't create new connection.\nActivate or create new project.");
            return 1;
        }
        try {
            return super.open();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Internal error", "Internal error when opening new connection wizard", (Throwable)e);
            return 1;
        }
    }
}

