/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDependenciesTree;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadWizard;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class DriverDownloadAutoPage
extends DriverDownloadPage {
    private DriverDependenciesTree depsTree;

    DriverDownloadAutoPage() {
        super(CoreMessages.dialog_driver_download_auto_page_auto_download, CoreMessages.dialog_driver_download_auto_page_download_driver_files, null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final DriverDownloadWizard wizard = this.getWizard();
        DBPDriver driver = wizard.getDriver();
        this.setMessage(NLS.bind((String)CoreMessages.dialog_driver_download_auto_page_download_specific_driver_files, (Object)driver.getFullName()));
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        if (!wizard.isForceDownload()) {
            Composite infoGroup = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            infoGroup.setLayoutData((Object)new GridData(768));
            Label infoText = new Label(infoGroup, 0);
            infoText.setText(NLS.bind((String)CoreMessages.dialog_driver_download_auto_page_driver_file_missing_text, (Object)driver.getFullName()));
            infoText.setLayoutData((Object)new GridData(768));
            final Button forceCheckbox = UIUtils.createCheckbox((Composite)infoGroup, (String)CoreMessages.dialog_driver_download_auto_page_force_download, (boolean)wizard.isForceDownload());
            forceCheckbox.setToolTipText(CoreMessages.dialog_driver_download_auto_page_force_download_tooltip);
            forceCheckbox.setLayoutData((Object)new GridData(130));
            forceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    wizard.setForceDownload(forceCheckbox.getSelection());
                }
            });
        }
        Group filesGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_driver_download_auto_page_required_files, (int)1, (int)-1, (int)-1);
        filesGroup.setLayoutData((Object)new GridData(1808));
        this.depsTree = new DriverDependenciesTree((Composite)filesGroup, (DBRRunnableContext)new RunnableContextDelegate((IRunnableContext)this.getContainer()), this.getWizard().getDependencies(), driver, driver.getDriverLibraries(), true){

            @Override
            protected void setLibraryVersion(DBPDriverLibrary library, String version) {
                String curVersion = library.getVersion();
                if (CommonUtils.equalObjects((Object)curVersion, (Object)version)) {
                    return;
                }
                library.setPreferredVersion(version);
                this.resolveLibraries();
            }
        };
        new Label((Composite)filesGroup, 0).setText(CoreMessages.dialog_driver_download_auto_page_change_driver_version_text);
        if (!wizard.isForceDownload()) {
            Label infoText = new Label(composite, 0);
            infoText.setText(CoreMessages.dialog_driver_download_auto_page_obtain_driver_files_text);
            infoText.setLayoutData((Object)new GridData(768));
        }
        this.createLinksPanel(composite);
        this.setControl((Control)composite);
    }

    @Override
    void resolveLibraries() {
        if (!this.depsTree.resolveLibraries()) {
            this.setErrorMessage(CoreMessages.dialog_driver_download_auto_page_cannot_resolve_libraries_text);
        }
        this.depsTree.resizeTree();
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DriverDownloadAutoPage.this.downloadLibraryFiles((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_driver_download_auto_page_driver_download_error, CoreMessages.dialog_driver_download_auto_page_driver_download_error_msg, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void downloadLibraryFiles(final DBRProgressMonitor monitor) throws InterruptedException {
        if (!this.acceptDriverLicenses()) {
            return;
        }
        boolean processUnsecure = false;
        List nodes = this.getWizard().getDependencies().getLibraryList();
        int i = 0;
        int filesSize = nodes.size();
        while (i < filesSize) {
            final DBPDriverLibrary lib = ((DBPDriverDependencies.DependencyNode)nodes.get((int)i)).library;
            if (!processUnsecure && !lib.isSecureDownload(monitor)) {
                boolean process = (Boolean)new UIConfirmation(){

                    protected Boolean runTask() {
                        MessageBox messageBox = new MessageBox(DriverDownloadAutoPage.this.getShell(), 200);
                        messageBox.setText(CoreMessages.dialog_driver_download_auto_page_driver_security_warning);
                        messageBox.setMessage(NLS.bind((String)CoreMessages.dialog_driver_download_auto_page_driver_security_warning_msg, (Object)lib.getDisplayName(), (Object)lib.getExternalURL(monitor)));
                        int response = messageBox.open();
                        if (response == 64) {
                            return true;
                        }
                        return false;
                    }
                }.execute();
                if (!process) break;
                processUnsecure = true;
            }
            int result = 0;
            try {
                lib.downloadLibraryFile(monitor, this.getWizard().isForceDownload(), NLS.bind((String)CoreMessages.dialog_driver_download_auto_page_download_rate, (Object)(i + 1), (Object)filesSize));
            }
            catch (IOException e) {
                result = lib.getType() == DBPDriverLibrary.FileType.license ? 0 : (Integer)new UITask<Integer>(){

                    protected Integer runTask() {
                        DownloadErrorDialog dialog = new DownloadErrorDialog(null, lib.getDisplayName(), CoreMessages.dialog_driver_download_auto_page_download_failed_msg, e);
                        return dialog.open();
                    }
                }.execute();
            }
            switch (result) {
                case 1: 
                case 7: {
                    return;
                }
                case 8: {
                    break;
                }
                case 0: 
                case 9: {
                    ++i;
                }
            }
        }
        ((DriverDescriptor)this.getWizard().getDriver()).setModified(true);
    }

    private boolean acceptDriverLicenses() {
        DBPDriver driver = this.getWizard().getDriver();
        if (!driver.isLicenseRequired()) {
            return true;
        }
        String license = driver.getLicense();
        if (CommonUtils.isEmpty((String)license)) {
            return true;
        }
        return DBWorkbench.getPlatformUI().acceptLicense("You have to accept driver '" + driver.getFullName() + "' license to continue", license);
    }

    public static class DownloadErrorDialog
    extends StandardErrorDialog {
        DownloadErrorDialog(Shell parentShell, String dialogTitle, String message, Throwable error) {
            super(parentShell, dialogTitle, message, GeneralUtils.makeExceptionStatus((Throwable)error), 7);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 7, IDialogConstants.ABORT_LABEL, true);
            this.createButton(parent, 8, IDialogConstants.RETRY_LABEL, false);
            this.createButton(parent, 9, IDialogConstants.IGNORE_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 13) {
                super.buttonPressed(buttonId);
            } else {
                this.setReturnCode(buttonId);
                this.close();
            }
        }
    }
}

