/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class SQLServerToolRebuild
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, SQLServerTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        public SQLDialog(IWorkbenchPartSite partSite, Collection<SQLServerTable> selectedTables) {
            super(partSite, "Rebuild index(s)", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, SQLServerObject object) {
            lines.add("ALTER INDEX ALL ON " + ((SQLServerTable)object).getFullyQualifiedName(DBPEvaluationContext.DDL) + " REBUILD ");
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }
    }
}

