/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesPanel;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class ClientHomesSelector {
    private Composite selectorPanel;
    private Combo homesCombo;
    private DBPDriver driver;
    private List<String> homeIds = new ArrayList<String>();
    private String currentHomeId;

    public ClientHomesSelector(Composite parent, String title) {
        this.selectorPanel = UIUtils.createComposite((Composite)parent, (int)2);
        Label controlLabel = UIUtils.createControlLabel((Composite)this.selectorPanel, (String)title);
        controlLabel.setToolTipText("Local client configuration is needed for some administrative tasks like database dump/restore.");
        this.homesCombo = new Combo(this.selectorPanel, 8);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.homesCombo.setLayoutData((Object)gd);
        this.homesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientHomesSelector.this.homesCombo.getSelectionIndex() == ClientHomesSelector.this.homesCombo.getItemCount() - 1) {
                    ClientHomesSelector.this.manageHomes();
                } else {
                    ClientHomesSelector.this.currentHomeId = (String)ClientHomesSelector.this.homeIds.get(ClientHomesSelector.this.homesCombo.getSelectionIndex());
                }
                ClientHomesSelector.this.displayClientVersion();
                ClientHomesSelector.this.handleHomeChange();
            }
        });
    }

    public Composite getPanel() {
        return this.selectorPanel;
    }

    private void manageHomes() {
        String newHomeId = ClientHomesPanel.chooseClientHome(this.selectorPanel.getShell(), this.driver);
        if (newHomeId != null) {
            this.currentHomeId = newHomeId;
        }
        this.populateHomes(this.driver, this.currentHomeId, false);
    }

    public void populateHomes(DBPDriver driver, String currentHome, boolean selectDefault) {
        this.driver = driver;
        this.currentHomeId = currentHome;
        this.homesCombo.removeAll();
        this.homeIds.clear();
        LinkedHashSet<DBPNativeClientLocation> homes = new LinkedHashSet<DBPNativeClientLocation>();
        homes.addAll(driver.getNativeClientLocations());
        DBPNativeClientLocationManager clientManager = driver.getNativeClientManager();
        if (clientManager != null) {
            for (DBPNativeClientLocation location : clientManager.findLocalClientLocations()) {
                if (homes.contains(location)) continue;
                homes.add(location);
            }
        }
        this.homesCombo.add("");
        this.homeIds.add(null);
        for (DBPNativeClientLocation location : homes) {
            this.homesCombo.add(location.getDisplayName());
            this.homeIds.add(location.getName());
            if (this.currentHomeId == null || !location.getName().equals(this.currentHomeId)) continue;
            this.homesCombo.select(this.homesCombo.getItemCount() - 1);
        }
        if (selectDefault && this.homesCombo.getItemCount() > 1 && this.homesCombo.getSelectionIndex() == -1) {
            this.homesCombo.select(1);
        }
        this.homesCombo.add(UIConnectionMessages.controls_client_home_selector_browse);
        this.displayClientVersion();
    }

    private void displayClientVersion() {
    }

    protected void handleHomeChange() {
    }

    public String getSelectedHome() {
        return CommonUtils.isEmpty((String)this.currentHomeId) ? null : this.currentHomeId;
    }
}

