/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndexColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.ByteNumberFormat;

public class PostgreIndex
extends JDBCTableIndex<PostgreSchema, PostgreTableBase>
implements PostgreObject,
PostgreScriptObject {
    private long indexId;
    private boolean isUnique;
    private boolean isPrimary;
    private boolean isExclusion;
    private boolean isImmediate;
    private boolean isClustered;
    private boolean isValid;
    private boolean isCheckXMin;
    private boolean isReady;
    private String description;
    private List<PostgreIndexColumn> columns = new ArrayList<PostgreIndexColumn>();
    private long amId;
    private long tablespaceId;
    private String predicateExpression;
    private long indexRelSize;
    private long indexNumScans;
    private transient boolean isPrimaryKeyIndex;
    private transient String indexDDL;

    public PostgreIndex(DBRProgressMonitor monitor, PostgreTableBase parent, String indexName, ResultSet dbResult) throws DBException {
        super((DBSObjectContainer)((PostgreTableContainer)parent.getContainer()).getSchema(), (JDBCTable)parent, indexName, DBSIndexType.UNKNOWN, true);
        PostgreTableConstraintBase ownerConstraint;
        this.indexId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"indexrelid");
        this.isUnique = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisunique");
        this.isPrimary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisprimary");
        this.isExclusion = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisexclusion");
        this.isImmediate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indimmediate");
        this.isClustered = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisclustered");
        this.isValid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisvalid");
        this.isCheckXMin = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indcheckxmin");
        this.isReady = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"indisready");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.amId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relam");
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltablespace");
        if (this.getDataSource().isServerVersionAtLeast(7, 4)) {
            this.predicateExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"pred_expr");
        }
        if (this.getDataSource().getServerType().supportsRelationSizeCalc()) {
            this.indexRelSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"index_rel_size");
            this.indexNumScans = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"index_num_scans");
        }
        if (this.isUnique && (ownerConstraint = parent.getConstraint(monitor, this.getName())) != null && ownerConstraint.getConstraintType().isUnique()) {
            this.isPrimaryKeyIndex = true;
        }
    }

    public PostgreIndex(PostgreTableBase parent, String name, DBSIndexType indexType, boolean unique) {
        super((DBSObjectContainer)((PostgreTableContainer)parent.getContainer()).getSchema(), (JDBCTable)parent, name, indexType, false);
        this.isUnique = unique;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)((PostgreTableBase)this.getTable()).getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreTableBase)this.getTable()).getDatabase();
    }

    public long getObjectId() {
        return this.indexId;
    }

    @Property(viewable=true, order=5)
    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    @Property(viewable=false, order=20)
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Property(viewable=false, order=21)
    public boolean isExclusion() {
        return this.isExclusion;
    }

    @Property(viewable=false, order=22)
    public boolean isImmediate() {
        return this.isImmediate;
    }

    @Property(viewable=false, order=23)
    public boolean isClustered() {
        return this.isClustered;
    }

    @Property(viewable=false, order=24)
    public boolean isValid() {
        return this.isValid;
    }

    @Property(viewable=false, order=25)
    public boolean isCheckXMin() {
        return this.isCheckXMin;
    }

    @Property(viewable=false, order=26)
    public boolean isReady() {
        return this.isReady;
    }

    public DBSIndexType getIndexType() {
        return super.getIndexType();
    }

    @Property(viewable=true, order=27)
    public String getPredicateExpression() {
        return this.predicateExpression;
    }

    @Property(viewable=true, order=28, formatter=ByteNumberFormat.class)
    public long getIndexRelSize() {
        return this.indexRelSize;
    }

    @Property(viewable=false, order=29)
    public long getIndexNumScans() {
        return this.indexNumScans;
    }

    @Property(viewable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=30)
    @Nullable
    public PostgreAccessMethod getAccessMethod(DBRProgressMonitor monitor) throws DBException {
        if (this.amId <= 0L) {
            return null;
        }
        return (PostgreAccessMethod)PostgreUtils.getObjectById(monitor, ((PostgreTableBase)this.getTable()).getDatabase().accessMethodCache, ((PostgreTableBase)this.getTable()).getDatabase(), this.amId);
    }

    @Property(viewable=true, order=31)
    @Nullable
    public PostgreTablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespaceId <= 0L) {
            return this.getDatabase().getDefaultTablespace(monitor);
        }
        return this.getDatabase().getTablespace(monitor, this.tablespaceId);
    }

    public List<PostgreIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public PostgreIndexColumn getColumn(String columnName) {
        return (PostgreIndexColumn)DBUtils.findObject(this.columns, (String)columnName);
    }

    void setColumns(List<PostgreIndexColumn> columns) {
        this.columns = columns;
    }

    public void addColumn(PostgreIndexColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<PostgreIndexColumn>();
        }
        this.columns.add(column);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((PostgreTableBase)this.getTable()).getContainer(), this});
    }

    public boolean isPrimaryKeyIndex() {
        return this.isPrimaryKeyIndex;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.indexDDL == null && this.isPersisted()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read index definition");){
                    this.indexDDL = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT pg_catalog.pg_get_indexdef(?)", (Object[])new Object[]{this.indexId});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        return this.indexDDL;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.columns + ")";
    }
}

