/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.ExecuteToolHandler;
import org.jkiss.dbeaver.tools.registry.ToolDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolGroupDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.EmptyListAction;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceToolsContributor
extends DataSourceMenuContributor {
    private static final boolean SHOW_GROUPS_AS_SUBMENU = false;

    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IEditorInput editorInput;
        IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return;
        }
        DBSObject selectedObject = null;
        ISelectionProvider selectionProvider = activePart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                selectedObject = (DBSObject)RuntimeUtils.getObjectAdapter((Object)((IStructuredSelection)selection).getFirstElement(), DBSObject.class);
                List<ToolDescriptor> tools = ToolsRegistry.getInstance().getTools((IStructuredSelection)selection);
                DataSourceToolsContributor.fillToolsMenu(menuItems, tools, selection);
            }
        } else if (activePart instanceof IEditorPart && (editorInput = ((IEditorPart)activePart).getEditorInput()) instanceof IDatabaseEditorInput) {
            selectedObject = ((IDatabaseEditorInput)editorInput).getDatabaseObject();
        }
        if (selectedObject != null) {
            DBPDataSource dataSource = selectedObject.getDataSource();
            DBPDataSourceContainer dataSourceContainer = dataSource.getContainer();
            DBPEditorContribution[] contributedEditors = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getContributedEditors("connectionEditor", dataSourceContainer);
            if (contributedEditors.length > 0) {
                menuItems.add((IContributionItem)new Separator());
                DBPEditorContribution[] dBPEditorContributionArray = contributedEditors;
                int n = contributedEditors.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPEditorContribution ec = dBPEditorContributionArray[n2];
                    menuItems.add((IContributionItem)new ActionContributionItem((IAction)new OpenToolsEditorAction(activePage, dataSource, ec)));
                    ++n2;
                }
            }
        }
        menuItems.add((IContributionItem)new Separator());
        menuItems.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)activePart.getSite(), (String)"org.jkiss.dbeaver.task.create"));
    }

    private void findObjectNodes(DBXTreeNode meta, List<DBXTreeObject> editors, Set<DBXTreeNode> processedNodes) {
        if (processedNodes.contains(meta)) {
            return;
        }
        if (meta instanceof DBXTreeObject) {
            editors.add((DBXTreeObject)meta);
        }
        processedNodes.add(meta);
        if (meta.getRecursiveLink() != null) {
            return;
        }
        List children = meta.getChildren(null);
        if (children != null) {
            for (DBXTreeNode child : children) {
                this.findObjectNodes(child, editors, processedNodes);
            }
        }
    }

    private static void fillToolsMenu(List<IContributionItem> menuItems, List<ToolDescriptor> tools, ISelection selection) {
        IWorkbenchPart activePart;
        IWorkbenchWindow workbenchWindow;
        boolean hasTools = false;
        if (!CommonUtils.isEmpty(tools) && (workbenchWindow = UIUtils.getActiveWorkbenchWindow()).getActivePage() != null && (activePart = workbenchWindow.getActivePage().getActivePart()) != null) {
            HashMap groupsMap = new HashMap();
            HashSet<ToolGroupDescriptor> groupSet = new HashSet<ToolGroupDescriptor>();
            for (ToolDescriptor tool : tools) {
                hasTools = true;
                Object parentMenu = null;
                if (tool.getGroup() != null && !groupSet.contains((Object)tool.getGroup())) {
                    groupSet.add(tool.getGroup());
                    menuItems.add((IContributionItem)new Separator(tool.getGroup().getId()));
                }
                IAction action = ActionUtils.makeAction((IActionDelegate)new ExecuteToolHandler(workbenchWindow, tool), (IWorkbenchSite)activePart.getSite(), (ISelection)selection, (String)tool.getLabel(), (ImageDescriptor)(tool.getIcon() == null ? null : DBeaverIcons.getImageDescriptor((DBPImage)tool.getIcon())), (String)tool.getDescription());
                if (parentMenu == null) {
                    menuItems.add((IContributionItem)new ActionContributionItem(action));
                    continue;
                }
                parentMenu.add((IContributionItem)new ActionContributionItem(action));
            }
        }
        if (!hasTools) {
            menuItems.add((IContributionItem)new ActionContributionItem((IAction)new EmptyListAction()));
        }
    }

    private static IMenuManager getGroupMenu(List<IContributionItem> rootItems, Map<ToolGroupDescriptor, IMenuManager> groupsMap, ToolGroupDescriptor group) {
        IMenuManager item = groupsMap.get((Object)group);
        if (item == null) {
            item = new MenuManager(group.getLabel(), null, group.getId());
            if (group.getParent() != null) {
                IMenuManager parentMenu = DataSourceToolsContributor.getGroupMenu(rootItems, groupsMap, group.getParent());
                parentMenu.add((IContributionItem)item);
            } else {
                rootItems.add((IContributionItem)item);
            }
        }
        groupsMap.put(group, item);
        return item;
    }

    public class DataSourceEditorInput
    implements IEditorInput,
    IDataSourceContainerProvider,
    DBPContextProvider {
        private final DBPDataSource dataSource;
        private final DBPEditorContribution editor;

        public DataSourceEditorInput(DBPDataSource dataSource, DBPEditorContribution editor) {
            this.dataSource = dataSource;
            this.editor = editor;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return DBeaverIcons.getImageDescriptor((DBPImage)this.editor.getIcon());
        }

        public String getName() {
            return this.editor.getLabel();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.editor.getDescription();
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public DBPDataSourceContainer getDataSourceContainer() {
            return this.dataSource.getContainer();
        }

        public DBCExecutionContext getExecutionContext() {
            return DBUtils.getDefaultContext((DBSObject)this.dataSource, (boolean)false);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DataSourceEditorInput && ((DataSourceEditorInput)obj).editor == this.editor;
        }
    }

    private class OpenToolsEditorAction
    extends Action {
        private final IWorkbenchPage workbenchPage;
        private final DBPDataSource dataSource;
        private final DBPEditorContribution editor;

        public OpenToolsEditorAction(IWorkbenchPage workbenchPage, DBPDataSource dataSource, DBPEditorContribution editor) {
            super(editor.getLabel(), DBeaverIcons.getImageDescriptor((DBPImage)editor.getIcon()));
            this.workbenchPage = workbenchPage;
            this.dataSource = dataSource;
            this.editor = editor;
        }

        public void run() {
            try {
                this.workbenchPage.openEditor((IEditorInput)new DataSourceEditorInput(this.dataSource, this.editor), this.editor.getEditorId());
            }
            catch (PartInitException e) {
                DBWorkbench.getPlatformUI().showError("Editor open", "Error opening tool editor '" + this.editor.getEditorId() + "'", e.getStatus());
            }
        }
    }
}

