/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskConfigurationDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public abstract class TaskConfigurationWizard
extends BaseWizard
implements IWorkbenchWizard {
    private DBTTask currentTask;
    private IStructuredSelection currentSelection;
    private Button saveAsTaskButton;

    protected TaskConfigurationWizard() {
    }

    protected TaskConfigurationWizard(@Nullable DBTTask task) {
        this.currentTask = task;
    }

    protected abstract String getDefaultWindowTitle();

    public boolean isTaskEditor() {
        return this.currentTask != null;
    }

    public abstract String getTaskTypeId();

    public abstract void saveTaskState(DBRRunnableContext var1, Map<String, Object> var2);

    public boolean isRunTaskOnFinish() {
        return false;
    }

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public DBTTask getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(DBTTask currentTask) {
        this.currentTask = currentTask;
        this.updateWizardTitle();
        this.getContainer().updateButtons();
    }

    public DBPProject getProject() {
        return this.currentTask != null ? this.currentTask.getProject() : NavigatorUtils.getSelectedProject();
    }

    public DBTTaskType getTaskType() {
        return TaskRegistry.getInstance().getTaskType(this.getTaskTypeId());
    }

    protected void updateWizardTitle() {
        String wizTitle = this.getDefaultWindowTitle();
        if (this.isTaskEditor()) {
            TaskConfigurationWizardPageTask taskPage = this.getContainer() == null ? null : this.getContainer().getTaskPage();
            wizTitle = String.valueOf(wizTitle) + " - [" + (taskPage == null ? this.currentTask.getName() : taskPage.getTaskName()) + "]";
        }
        this.setWindowTitle(wizTitle);
    }

    public TaskConfigurationWizardDialog getContainer() {
        return (TaskConfigurationWizardDialog)super.getContainer();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.updateWizardTitle();
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
        this.getContainer().addPageChangedListener(event -> this.updateWizardTitle());
    }

    public void addPages() {
        super.addPages();
        if (this.isCurrentTaskSaved()) {
            this.addPage((IWizardPage)new TaskConfigurationWizardPageTask(this.getCurrentTask()));
        }
    }

    public boolean isCurrentTaskSaved() {
        return this.getCurrentTask() != null && this.getCurrentTask().getProject().getTaskManager().getTaskById(this.getCurrentTask().getId()) != null;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (this.isPageValid(page) && !page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
        return taskPage == null || taskPage.isPageComplete();
    }

    public boolean performFinish() {
        if (this.currentTask != null) {
            this.saveTask();
        }
        return !this.isRunTaskOnFinish() || this.runTask();
    }

    protected boolean runTask() {
        try {
            DBTTask task = this.getCurrentTask();
            if (task == null) {
                task = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getWindowTitle());
                this.saveConfigurationToTask(task);
            }
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), task);
            if (this.getCurrentTask() == null) {
                executor.executeTask();
            } else {
                task.getProject().getTaskManager().runTask(task, (DBTTaskExecutionListener)executor, Collections.emptyMap());
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task run error", e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean isPageValid(IWizardPage page) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveTask() {
        DBTTask currentTask = this.getCurrentTask();
        if (currentTask == null) {
            DBTTaskType taskType = this.getTaskType();
            if (taskType == null) {
                DBWorkbench.getPlatformUI().showError("No task type", "Can't find task type " + this.getTaskTypeId());
                return;
            }
            EditTaskConfigurationDialog dialog = new EditTaskConfigurationDialog(this.getContainer().getShell(), this.getProject(), taskType);
            if (dialog.open() != 0) return;
            currentTask = dialog.getTask();
            this.setCurrentTask(currentTask);
        } else {
            TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
            if (taskPage != null) {
                taskPage.saveSettings();
            }
        }
        DBTTask theTask = currentTask;
        this.saveConfigurationToTask(theTask);
    }

    protected void saveConfigurationToTask(DBTTask theTask) {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        this.saveTaskState(this.getRunnableContext(), state);
        theTask.setProperties(state);
        try {
            theTask.getProject().getTaskManager().updateTaskConfiguration(theTask);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task save error", "Error saving task configuration", (Throwable)e);
        }
    }

    public void createTaskSaveButtons(Composite parent, int hSpan) {
        Composite panel = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = hSpan;
            panel.setLayoutData((Object)gd);
        }
        panel.setLayout((Layout)new GridLayout(3, false));
        this.saveAsTaskButton = UIUtils.createDialogButton((Composite)panel, (String)(this.isTaskEditor() ? "Update configuration in task" : "Save configuration as task"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationWizard.this.saveTask();
            }
        });
        Link tasksLink = UIUtils.createLink((Composite)panel, (String)"<a>Open Tasks view</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    UIUtils.getActiveWorkbenchWindow().getActivePage().showView("org.jkiss.dbeaver.tasks");
                }
                catch (PartInitException e1) {
                    DBWorkbench.getPlatformUI().showError("Show view", "Error opening database tasks view", (Throwable)e1);
                }
            }
        });
        tasksLink.setLayoutData((Object)new GridData(128));
    }

    public void updateSaveTaskButtons() {
        if (this.saveAsTaskButton != null) {
            this.saveAsTaskButton.setEnabled(this.canFinish());
        }
    }
}

