/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class TaskHandlerNativeToolBase<BASE_OBJECT extends DBSObject, PROCESS_ARG>
implements DBTTaskHandler {
    private List<BASE_OBJECT> databaseObjects;
    private DBPNativeClientLocation clientHome;
    private DBPDataSourceContainer dataSourceContainer;
    private DBPConnectionConfiguration connectionInfo;
    private String toolUserName;
    private String toolUserPassword;
    private String extraCommandArgs;
    private boolean refreshObjects;
    private boolean isSuccess;

    public abstract Collection<PROCESS_ARG> getRunInfo(DBTTask var1);

    protected abstract List<String> getCommandLine(PROCESS_ARG var1) throws IOException;

    protected void setupProcessParameters(ProcessBuilder process) {
    }

    protected abstract void startProcessHandler(DBRProgressMonitor var1, PROCESS_ARG var2, ProcessBuilder var3, Process var4);

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    public boolean isVerbose() {
        return false;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    protected void onSuccess(long workTime) {
    }

    public List<BASE_OBJECT> getDatabaseObjects() {
        return this.databaseObjects;
    }

    public DBPConnectionConfiguration getConnectionInfo() {
        return this.connectionInfo;
    }

    public DBPNativeClientLocation getClientHome() {
        return this.clientHome;
    }

    public String getToolUserName() {
        return this.toolUserName;
    }

    public void setToolUserName(String toolUserName) {
        this.toolUserName = toolUserName;
    }

    public String getToolUserPassword() {
        return this.toolUserPassword;
    }

    public void setToolUserPassword(String toolUserPassword) {
        this.toolUserPassword = toolUserPassword;
    }

    public String getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(String extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    protected void addExtraCommandArgs(List<String> cmd) {
        if (!CommonUtils.isEmptyTrimmed((String)this.extraCommandArgs)) {
            Collections.addAll(cmd, this.extraCommandArgs.split(" "));
        }
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return null;
    }

    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull DBTTaskExecutionListener listener) throws DBException {
        log.debug((Object)(String.valueOf(task.getType().getName()) + " initiated"));
        try {
            runnableContext.run(true, true, monitor -> {
                this.loadToolSettings(monitor, task, log);
                if (!this.prepareTaskRun(monitor, task, log)) {
                    this.isSuccess = false;
                    return;
                }
                Collection<PROCESS_ARG> runList = this.getRunInfo(task);
                try {
                    this.isSuccess = true;
                    for (PROCESS_ARG arg : runList) {
                        if (!monitor.isCanceled()) {
                            if (this.executeProcess(monitor, task, log, arg)) continue;
                            this.isSuccess = false;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                boolean bl = this.refreshObjects = this.isSuccess && !monitor.isCanceled();
                if (this.refreshObjects && !CommonUtils.isEmpty(this.databaseObjects) && this.needsModelRefresh()) {
                    for (DBSObject object : this.databaseObjects) {
                        DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().findNode(object);
                        if (node == null) continue;
                        try {
                            node.refreshNode(monitor, (Object)this);
                        }
                        catch (DBException e) {
                            log.debug((Object)("Error refreshing node '" + node.getNodeItemPath() + "' after native tool execution"), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error executing native tool", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"Canceled");
        }
        log.debug((Object)(String.valueOf(task.getType().getName()) + " completed"));
    }

    protected boolean prepareTaskRun(DBRProgressMonitor monitor, DBTTask task, Log log) {
        return true;
    }

    private boolean executeProcess(DBRProgressMonitor monitor, DBTTask task, Log log, PROCESS_ARG arg) throws IOException, DBException, InterruptedException {
        monitor.beginTask(task.getName(), 1);
        List<String> commandLine = this.getCommandLine(arg);
        File execPath = new File(commandLine.get(0));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.directory(execPath.getParentFile());
        if (this.isMergeProcessStreams()) {
            processBuilder.redirectErrorStream(true);
        }
        this.setupProcessParameters(processBuilder);
        Process process = processBuilder.start();
        this.startProcessHandler(monitor, arg, processBuilder, process);
        Thread.sleep(100L);
        while (true) {
            Thread.sleep(100L);
            if (monitor.isCanceled()) {
                process.destroy();
            }
            try {
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    log.error((Object)("Process exit code: " + exitCode));
                    return false;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    continue;
                }
                catch (IOException e) {
                    monitor.done();
                    log.error((Object)e);
                    return false;
                }
            }
            break;
        }
        return true;
    }

    protected void loadToolSettings(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, Log log) {
        List databaseObjectList;
        String dsID;
        DBPProject project;
        String projectName = CommonUtils.toString(task.getProperties().get("project"));
        DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        if (project == null) {
            if (!CommonUtils.isEmpty((String)projectName)) {
                log.error((Object)("Can't find project '" + projectName + "' for tool configuration"));
            }
            project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        if (!CommonUtils.isEmpty((String)(dsID = CommonUtils.toString(task.getProperties().get("dataSource"))))) {
            this.dataSourceContainer = project.getDataSourceRegistry().getDataSource(dsID);
            if (this.dataSourceContainer == null) {
                log.error((Object)("Can't find datasource '" + dsID + "' in project '" + project.getName() + "' for tool configuration"));
            }
        }
        if (!CommonUtils.isEmpty((Collection)(databaseObjectList = (List)task.getProperties().get("databaseObjects")))) {
            DBPProject finalProject = project;
            for (String objectId : databaseObjectList) {
                try {
                    DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)finalProject, (String)objectId);
                    if (object == null) continue;
                    this.databaseObjects.add(object);
                }
                catch (Throwable throwable) {
                    log.error((Object)("Can't find database object '" + objectId + "' in project '" + finalProject.getName() + "' for task configuration"));
                }
            }
        }
        this.connectionInfo = this.dataSourceContainer == null ? null : this.dataSourceContainer.getActualConnectionConfiguration();
        this.toolUserName = CommonUtils.toString(task.getProperties().get("toolUserName"));
        this.toolUserPassword = CommonUtils.toString(task.getProperties().get("toolUserPassword"));
        this.extraCommandArgs = CommonUtils.toString(task.getProperties().get("extraArgs"));
    }
}

