/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNodePrimary;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="databaseTransferProducer")
public class DatabaseTransferProducer
implements IDataTransferProducer<DatabaseProducerSettings>,
IDataTransferNodePrimary {
    private static final Log log = Log.getLog(DatabaseTransferProducer.class);
    @NotNull
    private DBSDataContainer dataContainer;
    @Nullable
    private DBDDataFilter dataFilter;

    public DatabaseTransferProducer() {
    }

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        this.dataContainer = dataContainer;
        this.dataFilter = dataFilter;
    }

    public DBSDataContainer getDatabaseObject() {
        return this.dataContainer;
    }

    @Override
    public String getObjectName() {
        return this.dataContainer == null ? null : DBUtils.getObjectFullName((DBPNamedObject)this.dataContainer, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.dataContainer instanceof DBPImageProvider) {
            return DBValueFormatting.getObjectImage((DBPObject)this.dataContainer);
        }
        return DBIcon.TREE_TABLE;
    }

    @Override
    public String getObjectContainerName() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getName() : "?";
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getDriver().getIcon() : null;
    }

    private DBPDataSourceContainer getDataSourceContainer() {
        if (this.dataContainer != null) {
            return this.dataContainer.getDataSource().getContainer();
        }
        return null;
    }

    @Override
    public void transferData(DBRProgressMonitor monitor1, IDataTransferConsumer consumer, IDataTransferProcessor processor, DatabaseProducerSettings settings) throws DBException {
        String contextTask = DTMessages.data_transfer_wizard_job_task_export;
        DBSDataContainer databaseObject = this.getDatabaseObject();
        if (databaseObject == null) {
            throw new DBException("No input database object found");
        }
        DBPDataSource dataSource = databaseObject.getDataSource();
        assert (dataSource != null);
        DBExecUtils.tryExecuteRecover((Object)monitor1, (DBPDataSource)dataSource, monitor -> {
            block44: {
                long readFlags = 0L;
                if (settings.isSelectedColumnsOnly()) {
                    readFlags |= 8L;
                }
                if (settings.isSelectedRowsOnly()) {
                    readFlags |= 4L;
                }
                boolean newConnection = settings.isOpenNewConnections() && !this.getDatabaseObject().getDataSource().getContainer().getDriver().isEmbedded();
                boolean forceDataReadTransactions = Boolean.TRUE.equals(dataSource.getDataSourceFeature("datasource.lob-require-transactions"));
                boolean selectiveExportFromUI = settings.isSelectedColumnsOnly() || settings.isSelectedRowsOnly();
                try {
                    DBCExecutionContext context = this.dataContainer instanceof DBPContextProvider ? ((DBPContextProvider)this.dataContainer).getExecutionContext() : DBUtils.getDefaultContext((DBSObject)this.dataContainer, (boolean)false);
                    if (context == null) {
                        throw new DBCException("Can't retrieve execution context from data container " + this.dataContainer);
                    }
                    if (!selectiveExportFromUI && newConnection) {
                        context = DBUtils.getObjectOwnerInstance((DBSObject)this.getDatabaseObject()).openIsolatedContext(monitor, "Data transfer producer", context);
                    }
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, contextTask);){
                        try {
                            long totalRows;
                            AbstractExecutionSource transferSource;
                            block43: {
                                transferSource = new AbstractExecutionSource(this.dataContainer, context, (Object)consumer);
                                session.enableLogging(false);
                                if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions)) {
                                    try {
                                        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                                        if (txnManager != null) {
                                            txnManager.setAutoCommit(monitor, false);
                                        }
                                    }
                                    catch (DBCException e) {
                                        log.warn((Object)"Can't change auto-commit", (Throwable)e);
                                    }
                                }
                                totalRows = 0L;
                                if (settings.isQueryRowCount() && (this.dataContainer.getSupportedFeatures() & 1) != 0) {
                                    monitor.beginTask(DTMessages.data_transfer_wizard_job_task_retrieve, 1);
                                    try {
                                        try {
                                            totalRows = this.dataContainer.countData((DBCExecutionSource)transferSource, session, this.dataFilter, readFlags);
                                        }
                                        catch (Throwable e) {
                                            log.warn((Object)("Can't retrieve row count from '" + this.dataContainer.getName() + "'"), e);
                                            try {
                                                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                                                if (txnManager != null && !txnManager.isAutoCommit()) {
                                                    txnManager.rollback(session, null);
                                                }
                                            }
                                            catch (Throwable e1) {
                                                log.warn((Object)"Error rolling back transaction", e1);
                                            }
                                            monitor.done();
                                            break block43;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        monitor.done();
                                        throw throwable2;
                                    }
                                    monitor.done();
                                }
                            }
                            monitor.beginTask(DTMessages.data_transfer_wizard_job_task_export_table_data, (int)totalRows);
                            try {
                                DBCStatistics statistics;
                                monitor.subTask("Read data");
                                if (settings.getExtractType() == DatabaseProducerSettings.ExtractType.SINGLE_QUERY) {
                                    this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, -1L, -1L, readFlags, settings.getFetchSize());
                                    break block44;
                                }
                                long offset = 0L;
                                int segmentSize = settings.getSegmentSize();
                                while ((statistics = this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, offset, (long)segmentSize, readFlags, settings.getFetchSize())) != null) {
                                    if (statistics.getRowsFetched() < (long)segmentSize) {
                                        break;
                                    }
                                    offset += statistics.getRowsFetched();
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                        finally {
                            DBCTransactionManager txnManager;
                            if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions) && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null) {
                                try {
                                    txnManager.commit(session);
                                }
                                catch (DBCException e) {
                                    log.error((Object)"Can't finish transaction in data producer connection", (Throwable)e);
                                }
                            }
                            if (!selectiveExportFromUI && newConnection) {
                                context.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseTransferProducer && CommonUtils.equalObjects((Object)this.dataContainer, (Object)((DatabaseTransferProducer)obj).dataContainer) && CommonUtils.equalObjects((Object)this.dataFilter, (Object)((DatabaseTransferProducer)obj).dataFilter);
    }

    public static class ObjectSerializer
    implements DBPObjectSerializer<DBTTask, DatabaseTransferProducer> {
        public void serializeObject(DBRRunnableContext runnableContext, DatabaseTransferProducer object, Map<String, Object> state) {
            DBSDataContainer nestedDataContainer;
            DBSDataContainer dataContainer = object.dataContainer;
            if (dataContainer instanceof IAdaptable && (nestedDataContainer = (DBSDataContainer)((IAdaptable)dataContainer).getAdapter(DBSDataContainer.class)) != null) {
                dataContainer = nestedDataContainer;
            }
            if (dataContainer instanceof DBSEntity) {
                state.put("type", "entity");
                if (dataContainer.getDataSource() != null) {
                    state.put("project", dataContainer.getDataSource().getContainer().getProject().getName());
                }
                state.put("entityId", DBUtils.getObjectFullId((DBSObject)dataContainer));
            } else if (dataContainer instanceof SQLQueryContainer) {
                state.put("type", "query");
                SQLQueryContainer queryContainer = (SQLQueryContainer)dataContainer;
                DBPDataSourceContainer dataSource = queryContainer.getDataSourceContainer();
                if (dataSource != null) {
                    state.put("project", dataSource.getProject().getName());
                    state.put("dataSource", dataSource.getId());
                }
                state.put("query", queryContainer.getQuery());
            } else {
                state.put("type", "unknown");
                log.error((Object)("Unsupported producer data container: " + dataContainer));
            }
            if (object.dataFilter != null) {
                LinkedHashMap dataFilterState = new LinkedHashMap();
                object.dataFilter.serialize(dataFilterState);
                state.put("dataFilter", dataFilterState);
            }
        }

        public DatabaseTransferProducer deserializeObject(DBRRunnableContext runnableContext, DBTTask objectContext, Map<String, Object> state) throws DBCException {
            DatabaseTransferProducer producer = new DatabaseTransferProducer();
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        DBPProject project;
                        String selType = CommonUtils.toString(state.get("type"));
                        String projectName = CommonUtils.toString(state.get("project"));
                        DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                        if (project == null) {
                            project = objectContext.getProject();
                        }
                        switch (selType) {
                            case "entity": {
                                String id = CommonUtils.toString(state.get("entityId"));
                                producer.dataContainer = (DBSDataContainer)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)id);
                                break;
                            }
                            case "query": {
                                String dsId = CommonUtils.toString(state.get("dataSource"));
                                String queryText = CommonUtils.toString(state.get("query"));
                                DBPDataSourceContainer ds = project.getDataSourceRegistry().getDataSource(dsId);
                                if (ds == null) {
                                    log.debug((Object)("Can't find datasource " + dsId));
                                    return;
                                }
                                if (!ds.isConnected()) {
                                    ds.connect(monitor, true, true);
                                }
                                SQLQuery query = new SQLQuery(ds.getDataSource(), queryText);
                                producer.dataContainer = (DBSDataContainer)new SQLQueryDataContainer((DBPContextProvider)new DataSourceContextProvider((DBSObject)ds), query, null, log);
                                break;
                            }
                            default: {
                                log.warn((Object)("Unsupported selector type: " + selType));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new DBCException("Error instantiating data producer", e.getTargetException());
            }
            catch (InterruptedException e) {
                throw new DBCException("Deserialization canceled", (Throwable)e);
            }
            return producer;
        }
    }
}

