/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.IOUtils;

@DBSerializable(value="streamTransferConsumer")
public class StreamTransferConsumer
implements IDataTransferConsumer<StreamConsumerSettings, IStreamDataExporter> {
    private static final Log log = Log.getLog(StreamTransferConsumer.class);
    private static final String LOB_DIRECTORY_NAME = "files";
    public static final String VARIABLE_DATASOURCE = "datasource";
    public static final String VARIABLE_CATALOG = "catalog";
    public static final String VARIABLE_SCHEMA = "schema";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    public static final String VARIABLE_INDEX = "index";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_PROJECT = "project";
    public static final String VARIABLE_FILE = "file";
    public static final int OUT_FILE_BUFFER_SIZE = 100000;
    private IStreamDataExporter processor;
    private StreamConsumerSettings settings;
    private DBSDataContainer dataContainer;
    private OutputStream outputStream;
    private ZipOutputStream zipStream;
    private PrintWriter writer;
    private int multiFileNumber;
    private long bytesWritten = 0L;
    private DBDAttributeBinding[] columnMetas;
    private DBDAttributeBinding[] columnBindings;
    private File lobDirectory;
    private long lobCount;
    private File outputFile;
    private StreamExportSite exportSite;
    private Map<Object, Object> processorProperties;
    private StringWriter outputBuffer;
    private boolean initialized = false;
    private IDataTransferConsumer.TransferParameters parameters;

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        if (!this.initialized) {
            this.initExporter(session);
        }
        this.columnMetas = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.dataContainer, (DBCResultSetMetaData)resultSet.getMeta());
        this.columnBindings = this.processor instanceof IDocumentDataExporter ? DBUtils.injectAndFilterAttributeBindings((DBPDataSource)session.getDataSource(), (DBSDataContainer)this.dataContainer, (DBDAttributeBinding[])this.columnMetas, (boolean)true) : DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)this.dataContainer, (DBCResultSet)resultSet);
        if (!this.initialized) {
            try {
                this.processor.exportHeader(session);
            }
            catch (DBException e) {
                log.warn((Object)"Error while exporting table header", (Throwable)e);
            }
            catch (IOException e) {
                throw new DBCException("IO error", (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        try {
            Object[] targetRow;
            Object[] srcRow = StreamTransferConsumer.fetchRow(session, resultSet, this.columnMetas);
            if (this.processor instanceof IDocumentDataExporter) {
                targetRow = srcRow;
            } else {
                targetRow = new Object[this.columnBindings.length];
                int i = 0;
                while (i < this.columnBindings.length) {
                    DBDAttributeBinding column = this.columnBindings[i];
                    Object value = DBUtils.getAttributeValue((DBDAttributeBinding)column, (DBDAttributeBinding[])this.columnMetas, (Object[])srcRow);
                    if (value instanceof DBDContent && !this.settings.isOutputClipboard() && !ContentUtils.isTextContent((DBDContent)((DBDContent)value))) {
                        switch (this.settings.getLobExtractType()) {
                            case SKIP: {
                                value = null;
                                break;
                            }
                            case INLINE: {
                                break;
                            }
                            case FILES: {
                                value = this.saveContentToFile(session.getProgressMonitor(), (DBDContent)value);
                            }
                        }
                    }
                    targetRow[i] = value;
                    ++i;
                }
            }
            this.processor.exportRow(session, resultSet, targetRow);
            if (this.settings.isSplitOutFiles() && !this.parameters.isBinary) {
                this.writer.flush();
                if (this.bytesWritten >= this.settings.getMaxOutFileSize()) {
                    this.createNewOutFile();
                }
            }
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DBCException("Error while exporting table row", e);
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
    }

    public void close() {
        this.columnBindings = null;
    }

    private File saveContentToFile(DBRProgressMonitor monitor, DBDContent content) throws IOException, DBCException {
        DBDContentStorage contents = content.getContents(monitor);
        if (contents == null) {
            log.warn((Object)"Null value content");
            return null;
        }
        if (this.lobDirectory == null) {
            this.lobDirectory = new File(this.settings.getOutputFolder(), LOB_DIRECTORY_NAME);
            if (!this.lobDirectory.exists() && !this.lobDirectory.mkdir()) {
                throw new IOException("Can't create directory for CONTENT files: " + this.lobDirectory.getAbsolutePath());
            }
        }
        ++this.lobCount;
        Boolean extractImages = (Boolean)this.processorProperties.get("extractImages");
        String fileExt = extractImages != null && extractImages != false ? ".jpg" : ".data";
        File lobFile = new File(this.lobDirectory, String.valueOf(this.outputFile.getName()) + "-" + this.lobCount + fileExt);
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream cs = contents.getContentStream();){
            ContentUtils.saveContentToFile((InputStream)cs, (File)lobFile, (DBRProgressMonitor)monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lobFile;
    }

    private void initExporter(DBCSession session) throws DBCException {
        if (this.settings.getFormatterProfile() != null) {
            session.setDataFormatterProfile(this.settings.getFormatterProfile());
        }
        this.exportSite = new StreamExportSite();
        boolean outputClipboard = this.settings.isOutputClipboard();
        this.outputFile = !this.parameters.isBinary && outputClipboard ? null : this.makeOutputFile();
        try {
            if (outputClipboard) {
                this.outputBuffer = new StringWriter(2048);
                this.writer = new PrintWriter((Writer)this.outputBuffer, true);
            } else {
                this.openOutputStreams();
            }
        }
        catch (IOException e) {
            this.closeExporter();
            throw new DBCException("Data transfer IO error", (Throwable)e);
        }
        try {
            this.processor.init(this.exportSite);
        }
        catch (DBException e) {
            throw new DBCException("Can't initialize data exporter", (Throwable)e);
        }
    }

    private void closeExporter() {
        if (this.exportSite != null) {
            try {
                this.exportSite.flush();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        if (this.processor != null) {
            this.processor.dispose();
            this.processor = null;
        }
        this.closeOutputStreams();
    }

    private void openOutputStreams() throws IOException {
        byte[] bom;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile, this.settings.isUseSingleFile()), 100000);
        if (this.settings.isCompressResults()) {
            this.zipStream = new ZipOutputStream(this.outputStream);
            this.zipStream.putNextEntry(new ZipEntry(this.getOutputFileName()));
            this.outputStream = this.zipStream;
        }
        if (this.settings.isSplitOutFiles()) {
            this.outputStream = new OutputStreamStatProxy(this.outputStream);
        }
        if (!this.parameters.isBinary && this.settings.isOutputEncodingBOM() && (bom = GeneralUtils.getCharsetBOM((String)this.settings.getOutputEncoding())) != null) {
            this.outputStream.write(bom);
            this.outputStream.flush();
        }
        if (!this.parameters.isBinary) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, this.settings.getOutputEncoding()), true);
        }
    }

    private void closeOutputStreams() {
        if (this.writer != null) {
            this.writer.flush();
            ContentUtils.close((Closeable)this.writer);
            this.writer = null;
        }
        if (this.zipStream != null) {
            try {
                this.zipStream.closeEntry();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            try {
                this.zipStream.finish();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            this.zipStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            ContentUtils.close((Closeable)this.outputStream);
            this.outputStream = null;
        }
    }

    private void createNewOutFile() throws IOException {
        this.closeOutputStreams();
        this.bytesWritten = 0L;
        ++this.multiFileNumber;
        this.outputFile = this.makeOutputFile();
        this.openOutputStreams();
    }

    @Override
    public void initTransfer(DBSObject sourceObject, StreamConsumerSettings settings, IDataTransferConsumer.TransferParameters parameters, IStreamDataExporter processor, Map<Object, Object> processorProperties) {
        this.dataContainer = (DBSDataContainer)sourceObject;
        this.parameters = parameters;
        this.processor = processor;
        this.settings = settings;
        this.processorProperties = processorProperties;
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) {
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        if (!last) {
            if (this.processor != null) {
                try {
                    this.processor.exportFooter(monitor);
                }
                catch (Exception e) {
                    log.warn((Object)"Error while exporting table footer", (Throwable)e);
                }
            }
            this.closeExporter();
            if (!this.settings.isOutputClipboard() && this.settings.isExecuteProcessOnFinish()) {
                this.executeFinishCommand();
            }
            return;
        }
        if (!this.parameters.isBinary && this.settings.isOutputClipboard()) {
            if (this.outputBuffer != null) {
                String strContents = this.outputBuffer.toString();
                DBWorkbench.getPlatformUI().copyTextToClipboard(strContents, this.parameters.isHTML);
                this.outputBuffer = null;
            }
        } else if (this.settings.isOpenFolderOnFinish()) {
            DBWorkbench.getPlatformUI().executeShellProgram(this.settings.getOutputFolder());
        }
    }

    private void executeFinishCommand() {
        String commandLine = this.translatePattern(this.settings.getFinishProcessCommand(), this.outputFile);
        DBRShellCommand command = new DBRShellCommand(commandLine);
        DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command);
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Run process", "Error running process [" + commandLine + "]", (Throwable)e);
        }
    }

    @Override
    public String getObjectName() {
        return this.settings.isOutputClipboard() ? "Clipboard" : this.makeOutputFile().getName();
    }

    @Override
    public DBPImage getObjectIcon() {
        return null;
    }

    @Override
    public String getObjectContainerName() {
        return this.settings.isOutputClipboard() ? "Clipboard" : this.makeOutputFile().getParentFile().getAbsolutePath();
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        return this.settings.isOutputClipboard() ? DBIcon.TYPE_TEXT : DBIcon.TREE_FOLDER;
    }

    public String getOutputFileName() {
        Object extension = this.processorProperties == null ? null : this.processorProperties.get("extension");
        String fileName = this.translatePattern(this.settings.getOutputFilePattern(), null).trim();
        if (this.multiFileNumber > 0) {
            fileName = String.valueOf(fileName) + "_" + (this.multiFileNumber + 1);
        }
        if (extension != null) {
            return String.valueOf(fileName) + "." + extension;
        }
        return fileName;
    }

    public File makeOutputFile() {
        File dir = new File(this.settings.getOutputFolder());
        if (!dir.exists() && !dir.mkdirs()) {
            log.error((Object)("Can't create output directory '" + dir.getAbsolutePath() + "'"));
        }
        String fileName = this.getOutputFileName();
        if (this.settings.isCompressResults()) {
            fileName = String.valueOf(fileName) + ".zip";
        }
        return new File(dir, fileName);
    }

    private String translatePattern(String pattern, File targetFile) {
        return GeneralUtils.replaceVariables((String)pattern, name -> {
            switch (name) {
                case "datasource": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    return StreamTransferConsumer.stripObjectName(this.dataContainer.getDataSource().getContainer().getName());
                }
                case "catalog": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)this.dataContainer);
                    return catalog == null ? "" : StreamTransferConsumer.stripObjectName(catalog.getName());
                }
                case "schema": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)this.dataContainer);
                    return schema == null ? "" : StreamTransferConsumer.stripObjectName(schema.getName());
                }
                case "table": {
                    if (this.settings.isUseSingleFile()) {
                        return "export";
                    }
                    if (this.dataContainer == null) {
                        return null;
                    }
                    String tableName = DTUtils.getTableName(this.dataContainer.getDataSource(), (DBPNamedObject)this.dataContainer, true);
                    return StreamTransferConsumer.stripObjectName(tableName);
                }
                case "timestamp": {
                    Date ts = this.parameters.startTimestamp != null ? this.parameters.startTimestamp : new Date();
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.settings.getOutputTimestampPattern());
                        return sdf.format(ts);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        return "BAD_TIMESTAMP";
                    }
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
                case "index": {
                    return String.valueOf(this.parameters.orderNumber + 1);
                }
                case "project": {
                    if (this.dataContainer == null) {
                        return null;
                    }
                    DBPProject project = DBUtils.getObjectOwnerProject((DBSObject)this.dataContainer);
                    return project == null ? "" : project.getName();
                }
                case "file": {
                    return targetFile == null ? "" : targetFile.getAbsolutePath();
                }
            }
            return null;
        });
    }

    private static String stripObjectName(String name) {
        StringBuilder result = new StringBuilder();
        boolean lastUnd = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                lastUnd = false;
            } else if (!lastUnd) {
                result.append('_');
                lastUnd = true;
            }
            if (result.length() >= 64) break;
            ++i;
        }
        return result.toString();
    }

    @Override
    public DBSObject getDatabaseObject() {
        return null;
    }

    public static Object[] fetchRow(DBCSession session, DBCResultSet resultSet, DBDAttributeBinding[] attributes) throws DBCException {
        int columnCount = resultSet.getMeta().getAttributes().size();
        Object[] row = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            DBDAttributeBinding attribute = attributes[i];
            DBCAttributeMetaData metaAttr = attribute.getMetaAttribute();
            if (metaAttr != null) {
                try {
                    row[i] = attribute.getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)metaAttr, attribute.getOrdinalPosition());
                }
                catch (Exception e) {
                    log.debug((Object)("Error fetching '" + metaAttr.getName() + "' value: " + e.getMessage()));
                }
            }
            ++i;
        }
        return row;
    }

    public static class ObjectSerializer
    implements DBPObjectSerializer<DBTTask, StreamTransferConsumer> {
        public void serializeObject(DBRRunnableContext runnableContext, StreamTransferConsumer object, Map<String, Object> state) {
        }

        public StreamTransferConsumer deserializeObject(DBRRunnableContext runnableContext, DBTTask objectContext, Map<String, Object> state) {
            return new StreamTransferConsumer();
        }
    }

    private class OutputStreamStatProxy
    extends OutputStream {
        private final OutputStream out;

        OutputStreamStatProxy(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            StreamTransferConsumer streamTransferConsumer = StreamTransferConsumer.this;
            streamTransferConsumer.bytesWritten = streamTransferConsumer.bytesWritten + 1L;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.out.write(b);
            StreamTransferConsumer streamTransferConsumer = StreamTransferConsumer.this;
            streamTransferConsumer.bytesWritten = streamTransferConsumer.bytesWritten + (long)b.length;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            StreamTransferConsumer streamTransferConsumer = StreamTransferConsumer.this;
            streamTransferConsumer.bytesWritten = streamTransferConsumer.bytesWritten + (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private class StreamExportSite
    implements IStreamDataExporterSite {
        private StreamExportSite() {
        }

        @Override
        public DBPNamedObject getSource() {
            return StreamTransferConsumer.this.dataContainer;
        }

        @Override
        public DBDDisplayFormat getExportFormat() {
            DBDDisplayFormat format = DBDDisplayFormat.UI;
            Object formatProp = StreamTransferConsumer.this.processorProperties.get("format");
            if (formatProp != null) {
                format = DBDDisplayFormat.valueOf((String)formatProp.toString().toUpperCase(Locale.ENGLISH));
            }
            return format;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return StreamTransferConsumer.this.processorProperties;
        }

        @Override
        public DBDAttributeBinding[] getAttributes() {
            return StreamTransferConsumer.this.columnBindings;
        }

        @Override
        public OutputStream getOutputStream() {
            return StreamTransferConsumer.this.outputStream;
        }

        @Override
        public PrintWriter getWriter() {
            return StreamTransferConsumer.this.writer;
        }

        @Override
        public void flush() throws IOException {
            if (StreamTransferConsumer.this.writer != null) {
                StreamTransferConsumer.this.writer.flush();
            }
            if (StreamTransferConsumer.this.outputStream != null) {
                StreamTransferConsumer.this.outputStream.flush();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void writeBinaryData(@NotNull DBDContentStorage cs) throws IOException {
            if (((StreamTransferConsumer)StreamTransferConsumer.this).parameters.isBinary) {
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream stream = cs.getContentStream();){
                    IOUtils.copyStream((InputStream)stream, (OutputStream)StreamTransferConsumer.this.exportSite.getOutputStream());
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var3_8 = null;
            try (InputStream stream = cs.getContentStream();){
                StreamTransferConsumer.this.exportSite.flush();
                DBPDataSource dataSource = StreamTransferConsumer.this.dataContainer.getDataSource();
                switch (StreamTransferConsumer.this.settings.getLobEncoding()) {
                    case BASE64: {
                        Base64.encode((InputStream)stream, (long)cs.getContentLength(), (Writer)StreamTransferConsumer.this.writer);
                        return;
                    }
                    case HEX: {
                        StreamTransferConsumer.this.writer.write("0x");
                        byte[] buffer = new byte[5000];
                        while (true) {
                            int count;
                            if ((count = stream.read(buffer)) <= 0) {
                                return;
                            }
                            GeneralUtils.writeBytesAsHex((Writer)StreamTransferConsumer.this.writer, (byte[])buffer, (int)0, (int)count);
                        }
                    }
                    case NATIVE: {
                        if (dataSource != null) {
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)cs.getContentLength());
                            IOUtils.copyStream((InputStream)stream, (OutputStream)buffer);
                            byte[] bytes = buffer.toByteArray();
                            String binaryString = dataSource.getSQLDialect().getNativeBinaryFormatter().toString(bytes, 0, bytes.length);
                            StreamTransferConsumer.this.writer.write(binaryString);
                            return;
                        }
                    }
                    default: {
                        Throwable throwable3 = null;
                        Object var7_19 = null;
                        try (InputStreamReader reader = new InputStreamReader(stream, cs.getCharset());){
                            IOUtils.copyText((Reader)reader, (Writer)StreamTransferConsumer.this.writer);
                            return;
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }

        @Override
        public String getOutputEncoding() {
            return StreamTransferConsumer.this.settings == null ? null : StreamTransferConsumer.this.settings.getOutputEncoding();
        }
    }
}

