/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.rules.LineCommentRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLCommandRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterSetRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLParameterRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLVariableRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLWordRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockBeginToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockEndToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockHeaderToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLCommentToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLControlToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLDelimiterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLParameterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLSetDelimiterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLVariableToken;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.rules.EndOfLineRule;
import org.jkiss.dbeaver.model.text.parser.rules.MultiLineRule;
import org.jkiss.dbeaver.model.text.parser.rules.NumberRule;
import org.jkiss.dbeaver.model.text.parser.rules.SingleLineRule;
import org.jkiss.dbeaver.model.text.parser.rules.WhitespaceRule;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLRuleManager {
    @NotNull
    private TPRule[] allRules = new TPRule[0];
    @NotNull
    private SQLSyntaxManager syntaxManager;

    public SQLRuleManager(@NotNull SQLSyntaxManager syntaxManager) {
        this.syntaxManager = syntaxManager;
    }

    @NotNull
    public TPRule[] getAllRules() {
        return this.allRules;
    }

    public void refreshRules(@Nullable DBPDataSource dataSource, boolean minimalRules) {
        Pair multiLineComments;
        int n;
        int n2;
        String[][] stringArray;
        SQLDialect dialect = this.syntaxManager.getDialect();
        TPRuleProvider ruleProvider = (TPRuleProvider)GeneralUtils.adapt((Object)dialect, TPRuleProvider.class);
        DBPDataSourceContainer dataSourceContainer = dataSource == null ? null : dataSource.getContainer();
        TPTokenDefault keywordToken = new TPTokenDefault(SQLTokenType.T_KEYWORD);
        TPTokenDefault typeToken = new TPTokenDefault(SQLTokenType.T_TYPE);
        TPTokenDefault stringToken = new TPTokenDefault(SQLTokenType.T_STRING);
        TPTokenDefault quotedToken = new TPTokenDefault(SQLTokenType.T_QUOTED);
        TPTokenDefault numberToken = new TPTokenDefault(SQLTokenType.T_NUMBER);
        SQLCommentToken commentToken = new SQLCommentToken();
        SQLDelimiterToken delimiterToken = new SQLDelimiterToken();
        SQLParameterToken parameterToken = new SQLParameterToken();
        new SQLVariableToken();
        TPTokenDefault otherToken = new TPTokenDefault(SQLTokenType.T_OTHER);
        SQLBlockHeaderToken blockHeaderToken = new SQLBlockHeaderToken();
        SQLBlockBeginToken blockBeginToken = new SQLBlockBeginToken();
        SQLBlockEndToken blockEndToken = new SQLBlockEndToken();
        ArrayList<TPRule> rules = new ArrayList<TPRule>();
        if (ruleProvider != null) {
            ruleProvider.extendRules(dataSourceContainer, rules, TPRuleProvider.RulePosition.INITIAL);
        }
        String[] stringArray2 = dialect.getSingleLineComments();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String lineComment = stringArray2[n4];
            if (lineComment.startsWith("^")) {
                rules.add(new LineCommentRule(lineComment, commentToken));
            } else {
                rules.add(new EndOfLineRule(lineComment, commentToken));
            }
            ++n4;
        }
        if (ruleProvider != null) {
            ruleProvider.extendRules(dataSourceContainer, rules, TPRuleProvider.RulePosition.CONTROL);
        }
        if (!minimalRules) {
            SQLControlToken controlToken = new SQLControlToken();
            String commandPrefix = this.syntaxManager.getControlCommandPrefix();
            for (SQLCommandHandlerDescriptor controlCommand : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
                rules.add(new SQLCommandRule(commandPrefix, controlCommand, controlToken));
            }
        }
        if (!minimalRules && this.syntaxManager.isVariablesEnabled()) {
            rules.add(new SQLVariableRule(parameterToken));
        }
        if (!minimalRules) {
            Object quotes;
            char escapeChar = this.syntaxManager.getEscapeChar();
            String[][] identifierQuoteStrings = this.syntaxManager.getIdentifierQuoteStrings();
            String[][] stringQuoteStrings = this.syntaxManager.getStringQuoteStrings();
            boolean hasDoubleQuoteRule = false;
            if (!ArrayUtils.isEmpty((Object[])identifierQuoteStrings)) {
                stringArray = identifierQuoteStrings;
                n2 = identifierQuoteStrings.length;
                n = 0;
                while (n < n2) {
                    quotes = stringArray[n];
                    rules.add(new SingleLineRule(quotes[0], quotes[1], quotedToken, escapeChar));
                    if (((String)quotes[1]).equals("\"") && ((String)quotes[0]).equals(quotes[1])) {
                        hasDoubleQuoteRule = true;
                    }
                    ++n;
                }
            }
            if (!ArrayUtils.isEmpty((Object[])stringQuoteStrings)) {
                stringArray = stringQuoteStrings;
                n2 = stringQuoteStrings.length;
                n = 0;
                while (n < n2) {
                    quotes = stringArray[n];
                    rules.add(new MultiLineRule(quotes[0], quotes[1], stringToken, escapeChar));
                    ++n;
                }
            }
            if (!hasDoubleQuoteRule) {
                rules.add(new MultiLineRule("\"", "\"", quotedToken, escapeChar));
            }
        }
        if (ruleProvider != null) {
            ruleProvider.extendRules(dataSourceContainer, rules, TPRuleProvider.RulePosition.QUOTES);
        }
        if ((multiLineComments = dialect.getMultiLineComments()) != null) {
            rules.add(new MultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), commentToken, '\u0000', true));
        }
        if (!minimalRules) {
            rules.add(new WhitespaceRule(TPTokenAbstract.WHITESPACE));
            rules.add(new NumberRule(numberToken));
        }
        SQLDelimiterRule delimRule = new SQLDelimiterRule(this.syntaxManager.getStatementDelimiters(), delimiterToken);
        rules.add(delimRule);
        String delimRedefine = dialect.getScriptDelimiterRedefiner();
        if (!CommonUtils.isEmpty((String)delimRedefine)) {
            SQLSetDelimiterToken setDelimiterToken = new SQLSetDelimiterToken();
            rules.add(new SQLDelimiterSetRule(delimRedefine, setDelimiterToken, delimRule));
        }
        if (ruleProvider != null) {
            ruleProvider.extendRules(dataSourceContainer, rules, TPRuleProvider.RulePosition.KEYWORDS);
        }
        if (!minimalRules) {
            String[][] stringArray3;
            String[][] blockBounds;
            Object[] blockHeaderStrings;
            SQLWordRule wordRule = new SQLWordRule(delimRule, otherToken);
            for (String reservedWord : dialect.getReservedWords()) {
                wordRule.addWord(reservedWord, keywordToken);
            }
            if (dataSource != null) {
                for (String function : dialect.getFunctions(dataSource)) {
                    wordRule.addWord(function, typeToken);
                }
                for (String type : dialect.getDataTypes(dataSource)) {
                    wordRule.addWord(type, typeToken);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])(blockHeaderStrings = dialect.getBlockHeaderStrings()))) {
                stringArray = blockHeaderStrings;
                n2 = blockHeaderStrings.length;
                n = 0;
                while (n < n2) {
                    String[] bhs = stringArray[n];
                    wordRule.addWord((String)bhs, blockHeaderToken);
                    ++n;
                }
            }
            if ((blockBounds = dialect.getBlockBoundStrings()) != null) {
                stringArray3 = blockBounds;
                int n5 = blockBounds.length;
                n2 = 0;
                while (n2 < n5) {
                    String[] block = stringArray3[n2];
                    if (block.length == 2) {
                        wordRule.addWord(block[0], blockBeginToken);
                        wordRule.addWord(block[1], blockEndToken);
                    }
                    ++n2;
                }
            }
            rules.add(wordRule);
            stringArray3 = this.syntaxManager.getNamedParameterPrefixes();
            int n6 = stringArray3.length;
            n2 = 0;
            while (n2 < n6) {
                String[] npPrefix = stringArray3[n2];
                rules.add(new SQLParameterRule(this.syntaxManager, parameterToken, (String)npPrefix));
                ++n2;
            }
        }
        this.allRules = rules.toArray(new TPRule[0]);
    }
}

