/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectValidateAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureStandalone;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class OracleProcedureManager
extends SQLObjectEditor<OracleProcedureStandalone, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleProcedureStandalone> getObjectsCache(OracleProcedureStandalone object) {
        return object.getSchema().proceduresCache;
    }

    protected OracleProcedureStandalone createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new OracleProcedureStandalone((OracleSchema)container, "NEW_PROCEDURE", DBSProcedureType.PROCEDURE);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectCreateCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (OracleProcedureStandalone)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, Map<String, Object> options) {
        OracleProcedureStandalone object = (OracleProcedureStandalone)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + object.getProcedureType().name() + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand objectChangeCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actionList, (OracleProcedureStandalone)objectChangeCommand.getObject());
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actionList, OracleProcedureStandalone procedure) {
        String source = OracleUtils.normalizeSourceName(procedure, false);
        if (source == null) {
            return;
        }
        actionList.add((DBEPersistAction)new OracleObjectValidateAction(procedure, OracleObjectType.PROCEDURE, "Create procedure", source));
        OracleUtils.addSchemaChangeActions(actionList, procedure);
    }
}

