/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCCompositeStatic
extends JDBCComposite {
    private static final Log log = Log.getLog(JDBCCompositeStatic.class);

    public JDBCCompositeStatic(@NotNull JDBCComposite struct, @NotNull DBRProgressMonitor monitor) throws DBCException {
        super(struct, monitor);
    }

    public JDBCCompositeStatic(DBCSession session, @NotNull DBSDataType type, @Nullable Struct contents) throws DBCException {
        super(contents);
        this.type = type;
        try {
            Object[] attrValues;
            Object[] objectArray = attrValues = contents == null ? null : contents.getAttributes();
            if (type instanceof DBSEntity) {
                int valueCount;
                DBSEntity entity = (DBSEntity)((Object)type);
                Collection entityAttributes = CommonUtils.safeCollection(entity.getAttributes(session.getProgressMonitor()));
                int n = valueCount = attrValues == null ? 0 : attrValues.length;
                if (attrValues != null && entityAttributes.size() != valueCount) {
                    log.warn("Number of entity attributes (" + entityAttributes.size() + ") differs from real values (" + valueCount + ")");
                }
                this.attributes = entityAttributes.toArray(new DBSEntityAttribute[entityAttributes.size()]);
                this.values = new Object[this.attributes.length];
                int i = 0;
                while (i < this.attributes.length) {
                    DBSEntityAttribute attr = this.attributes[i];
                    int ordinalPosition = attr.getOrdinalPosition();
                    if (ordinalPosition < 0 || attrValues != null && ordinalPosition >= valueCount) {
                        log.warn("Attribute '" + attr.getName() + "' ordinal position (" + ordinalPosition + ") is out of range (" + valueCount + ")");
                    } else {
                        Object value = attrValues != null ? attrValues[ordinalPosition] : null;
                        DBDValueHandler valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)attr);
                        this.values[ordinalPosition] = value = valueHandler.getValueFromObject(session, attr, value, false);
                    }
                    ++i;
                }
            } else {
                this.attributes = EMPTY_ATTRIBUTE;
                this.values = EMPTY_VALUES;
            }
        }
        catch (DBException e) {
            throw new DBCException("Can't obtain attributes meta information", e);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Override
    public JDBCCompositeStatic cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new JDBCCompositeStatic(this, monitor);
    }

    @Override
    public String getStringRepresentation() {
        return Arrays.toString(this.values);
    }
}

