/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public abstract class SQLForeignKeyManager<OBJECT_TYPE extends JDBCTableConstraint<TABLE_TYPE>, TABLE_TYPE extends JDBCTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        JDBCTable table = (JDBCTable)((JDBCTableConstraint)command.getObject()).getTable();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_foreign_key, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.getNestedDeclaration(monitor, (TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options)));
    }

    @Override
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_foreign_key, this.getDropForeignKeyPattern((JDBCTableConstraint)command.getObject()).replace("%TABLE%", ((JDBCTable)((JDBCTableConstraint)command.getObject()).getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%CONSTRAINT%", DBUtils.getQuotedIdentifier((DBSObject)command.getObject()))));
    }

    @Override
    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        JDBCTableConstraint foreignKey = (JDBCTableConstraint)command.getObject();
        boolean legacySyntax = this.isLegacyForeignKeySyntax(owner);
        String constraintName = DBUtils.getQuotedIdentifier(foreignKey.getDataSource(), foreignKey.getName());
        StringBuilder decl = new StringBuilder(40);
        if (!legacySyntax || !foreignKey.isPersisted()) {
            decl.append("CONSTRAINT ");
        }
        if (!legacySyntax) {
            decl.append(constraintName).append(" ");
        }
        decl.append(foreignKey.getConstraintType().getName().toUpperCase(Locale.ENGLISH)).append(" (");
        try {
            List<? extends DBSEntityAttributeRef> columns = ((JDBCTableConstraint)command.getObject()).getAttributeReferences(new VoidProgressMonitor());
            boolean firstColumn = true;
            for (DBSEntityAttributeRef constraintColumn : CommonUtils.safeCollection(columns)) {
                DBSEntityAttribute attribute = constraintColumn.getAttribute();
                if (!firstColumn) {
                    decl.append(",");
                }
                firstColumn = false;
                if (attribute == null) continue;
                decl.append(DBUtils.getQuotedIdentifier(attribute));
            }
        }
        catch (DBException e) {
            log.error("Can't obtain reference attributes", e);
        }
        DBSEntityConstraint refConstraint = ((DBSTableForeignKey)((Object)foreignKey)).getReferencedConstraint();
        String refTableName = refConstraint == null ? "<?>" : DBUtils.getEntityScriptName(refConstraint.getParentObject(), options);
        decl.append(") REFERENCES ").append(refTableName).append("(");
        if (refConstraint instanceof DBSEntityReferrer) {
            try {
                boolean firstColumn = true;
                List<? extends DBSEntityAttributeRef> columns = ((DBSEntityReferrer)refConstraint).getAttributeReferences(new VoidProgressMonitor());
                for (DBSEntityAttributeRef constraintColumn : CommonUtils.safeCollection(columns)) {
                    if (!firstColumn) {
                        decl.append(",");
                    }
                    firstColumn = false;
                    DBSEntityAttribute attribute = constraintColumn.getAttribute();
                    if (attribute == null) continue;
                    decl.append(DBUtils.getQuotedIdentifier(attribute));
                }
            }
            catch (DBException e) {
                log.error("Can't obtain ref constraint reference attributes", e);
            }
        }
        decl.append(")");
        if (((DBSTableForeignKey)((Object)foreignKey)).getDeleteRule() != null && !CommonUtils.isEmpty((String)((DBSTableForeignKey)((Object)foreignKey)).getDeleteRule().getClause())) {
            decl.append(" ON DELETE ").append(((DBSTableForeignKey)((Object)foreignKey)).getDeleteRule().getClause());
        }
        if (((DBSTableForeignKey)((Object)foreignKey)).getUpdateRule() != null && !CommonUtils.isEmpty((String)((DBSTableForeignKey)((Object)foreignKey)).getUpdateRule().getClause())) {
            decl.append(" ON UPDATE ").append(((DBSTableForeignKey)((Object)foreignKey)).getUpdateRule().getClause());
        }
        if (legacySyntax) {
            decl.append(" CONSTRAINT ").append(constraintName);
        }
        return decl;
    }

    protected String getDropForeignKeyPattern(OBJECT_TYPE constraint) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    protected String getNewConstraintName(DBRProgressMonitor monitor, OBJECT_TYPE foreignKey) {
        DBSEntityConstraint uniqueKey = ((DBSTableForeignKey)foreignKey).getReferencedConstraint();
        DBSEntity targetTable = uniqueKey == null ? null : uniqueKey.getParentObject();
        JDBCTable table = (JDBCTable)((AbstractTableConstraint)foreignKey).getParentObject();
        String baseName = String.valueOf(CommonUtils.escapeIdentifier((String)table.getName())) + "_" + (uniqueKey == null ? "" : String.valueOf(CommonUtils.escapeIdentifier((String)targetTable.getName())) + "_") + "FK";
        DBSObjectCache<DBSObject, OBJECT_TYPE> objectsCache = this.getObjectsCache(foreignKey);
        if (objectsCache == null) {
            return baseName;
        }
        int i = 0;
        String constrName;
        OBJECT_TYPE child;
        while ((child = objectsCache.getCachedObject(constrName = DBObjectNameCaseTransformer.transformName(foreignKey.getDataSource(), i == 0 ? baseName : String.valueOf(baseName) + "_" + i))) != null) {
            ++i;
        }
        return constrName;
    }

    protected boolean isLegacyForeignKeySyntax(TABLE_TYPE owner) {
        return false;
    }
}

