/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class SSHImplementationAbstract
implements SSHImplementation {
    private static final Log log = Log.getLog(SSHImplementationAbstract.class);
    private transient int savedLocalPort = 0;
    protected transient DBWHandlerConfiguration savedConfiguration;
    protected transient DBPConnectionConfiguration savedConnectionInfo;
    protected AgentProxy agentProxy = null;

    @Override
    public DBPConnectionConfiguration initTunnel(DBRProgressMonitor monitor, DBPPlatform platform, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        String dbPortString = connectionInfo.getHostPort();
        if (CommonUtils.isEmpty((String)dbPortString) && CommonUtils.isEmpty((String)(dbPortString = configuration.getDriver().getDefaultPort()))) {
            throw new DBException("Database port not specified and no default port number for driver '" + configuration.getDriver().getName() + "'");
        }
        String sshAuthType = configuration.getStringProperty("authType");
        String sshHost = configuration.getStringProperty("host");
        int sshPortNum = configuration.getIntProperty("port");
        int aliveInterval = configuration.getIntProperty("aliveInterval");
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout");
        String sshLocalHost = CommonUtils.toString((Object)configuration.getProperty("localHost"));
        int sshLocalPort = configuration.getIntProperty("localPort");
        String sshRemoteHost = CommonUtils.toString((Object)configuration.getProperty("remoteHost"));
        int sshRemotePort = configuration.getIntProperty("remotePort");
        if (CommonUtils.isEmpty((String)sshHost)) {
            throw new DBException("SSH host not specified");
        }
        if (sshPortNum == 0) {
            throw new DBException("SSH port not specified");
        }
        if (CommonUtils.isEmpty((String)configuration.getUserName())) {
            throw new DBException("SSH user not specified");
        }
        if (sshLocalPort == 0) {
            if (this.savedLocalPort != 0) {
                sshLocalPort = this.savedLocalPort;
            } else if (platform != null) {
                sshLocalPort = SSHUtils.findFreePort(platform);
            }
        }
        if (CommonUtils.isEmpty((String)sshRemoteHost)) {
            sshRemoteHost = connectionInfo.getHostName();
        }
        if (sshRemotePort == 0 && configuration.getDriver() != null) {
            sshRemotePort = CommonUtils.toInt((Object)connectionInfo.getHostPort());
        }
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        if (sshAuthType != null) {
            authType = SSHConstants.AuthType.valueOf(sshAuthType);
        }
        File privKeyFile = null;
        String privKeyPath = configuration.getStringProperty("keyPath");
        if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
            if (CommonUtils.isEmpty((String)privKeyPath)) {
                throw new DBException("Private key path is empty");
            }
            privKeyFile = new File(privKeyPath);
            if (!privKeyFile.exists()) {
                throw new DBException("Private key file '" + privKeyFile.getAbsolutePath() + "' doesn't exist");
            }
        }
        if (authType == SSHConstants.AuthType.AGENT) {
            try {
                this.agentProxy = new AgentProxy((Connector)new PageantConnector());
                log.debug((Object)"SSH: Connected with pageant");
            }
            catch (Exception e) {
                log.debug((Object)"pageant connect exception", (Throwable)e);
            }
            if (this.agentProxy == null) {
                try {
                    NCUSocketFactory udsf = new NCUSocketFactory();
                    this.agentProxy = new AgentProxy((Connector)new SSHAgentConnector((USocketFactory)udsf));
                    log.debug((Object)"SSH: Connected with ssh-agent");
                }
                catch (Exception e) {
                    log.debug((Object)"ssh-agent connection exception", (Throwable)e);
                }
            }
            if (this.agentProxy == null) {
                throw new DBException("Unable to initialize SSH agent");
            }
        }
        if (connectTimeout == 0) {
            connectTimeout = 10000;
        }
        monitor.subTask("Initiating tunnel at '" + sshHost + "'");
        this.setupTunnel(monitor, configuration, sshHost, aliveInterval, sshPortNum, privKeyFile, connectTimeout, sshLocalHost, sshLocalPort, sshRemoteHost, sshRemotePort);
        this.savedLocalPort = sshLocalPort;
        this.savedConfiguration = configuration;
        this.savedConnectionInfo = connectionInfo;
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        if (CommonUtils.isEmpty((String)sshLocalHost)) {
            connectionInfo.setHostName("127.0.0.1");
        } else {
            connectionInfo.setHostName(sshLocalHost);
        }
        connectionInfo.setHostPort(Integer.toString(sshLocalPort));
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getDataSourceProvider().getConnectionURL(configuration.getDriver(), connectionInfo);
            connectionInfo.setUrl(newURL);
        }
        return connectionInfo;
    }

    public byte[] agentSign(byte[] blob, byte[] data) {
        return this.agentProxy.sign(blob, data);
    }

    protected List<SSHAgentIdentity> getAgentData() {
        Identity[] identities = this.agentProxy.getIdentities();
        List<SSHAgentIdentity> result = Arrays.asList(identities).stream().map(i -> {
            SSHAgentIdentity id = new SSHAgentIdentity();
            id.setBlob(i.getBlob());
            id.setComment(i.getComment());
            return id;
        }).collect(Collectors.toList());
        return result;
    }

    protected abstract void setupTunnel(DBRProgressMonitor var1, DBWHandlerConfiguration var2, String var3, int var4, int var5, File var6, int var7, String var8, int var9, String var10, int var11) throws DBException, IOException;
}

