/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.parser;

import java.io.Reader;
import java.util.Stack;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.ParseException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class KXml2SAXParser
extends KXmlParser {
    public KXml2SAXParser(Reader reader) throws XmlPullParserException {
        this.setInput(reader);
        this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
    }

    public void parseXML(KXml2SAXHandler handler) throws Exception {
        Stack<XmlElement> openElements = new Stack<XmlElement>();
        XmlElement currentElement = null;
        Attributes attributes = new Attributes();
        while (this.next() != 1) {
            handler.setLineNumber(this.getLineNumber());
            handler.setColumnNumber(this.getColumnNumber());
            if (this.getEventType() == 2) {
                currentElement = new XmlElement(this.getNamespace(), this.getName(), this.getLineNumber(), this.getColumnNumber());
                openElements.push(currentElement);
                handler.startElement(this.getNamespace(), this.getName(), attributes);
                continue;
            }
            if (this.getEventType() == 3) {
                this.ensureMatchingCurrentElement(currentElement);
                openElements.pop();
                currentElement = openElements.isEmpty() ? null : (XmlElement)openElements.peek();
                handler.endElement(this.getNamespace(), this.getName());
                continue;
            }
            if (this.getEventType() == 4) {
                String text = this.getText();
                handler.characters(text);
                continue;
            }
            if (this.getEventType() != 8) continue;
            handler.processingInstruction(null, this.getText());
        }
        if (!openElements.isEmpty()) {
            throw new ParseException("Unclosed elements found: " + openElements, null);
        }
    }

    private void ensureMatchingCurrentElement(XmlElement currentElement) throws Exception {
        if (currentElement == null) {
            throw new ParseException("Unexpected closing element " + new XmlElement(this.getNamespace(), this.getName(), this.getLineNumber(), this.getColumnNumber()), null);
        }
        if (!currentElement.match(this.getNamespace(), this.getName())) {
            throw new ParseException("Unexpected closing element " + new XmlElement(this.getNamespace(), this.getName(), this.getLineNumber(), this.getColumnNumber()) + ": Does not match opening element " + currentElement, null);
        }
    }

    public class Attributes {
        public String getAttribute(String name) {
            return KXml2SAXParser.this.getAttributeValue("", name);
        }

        public String getAttribute(String uri, String name) {
            return KXml2SAXParser.this.getAttributeValue(uri, name);
        }

        public boolean getBoolAttribute(String name, boolean defaultValue) {
            return this.getBoolAttribute("", name, defaultValue);
        }

        public boolean getBoolAttribute(String uri, String name, boolean defaultValue) {
            String val = this.getAttribute(uri, name);
            if (val != null) {
                return "true".equals(val);
            }
            return defaultValue;
        }
    }

    private static class XmlElement {
        final String namespaceUri;
        final String name;
        final int line;
        final int col;

        XmlElement(String namespaceUri, String name, int line, int col) {
            this.namespaceUri = namespaceUri;
            this.name = name;
            this.line = line;
            this.col = col;
        }

        boolean match(String namespaceUri, String name) {
            return namespaceUri.equals(this.namespaceUri) && name.equals(this.name);
        }

        public String toString() {
            return this.name + "@" + this.line + ":" + this.col;
        }
    }
}

