/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class PostgrePrivilege
implements DBAPrivilege,
Comparable<PostgrePrivilege> {
    public static final short NONE = 0;
    public static final short GRANTED = 1;
    public static final short WITH_GRANT_OPTION = 2;
    public static final short WITH_HIERARCHY = 4;
    protected final PostgrePrivilegeOwner owner;
    private ObjectPermission[] permissions;

    public PostgrePrivilege(PostgrePrivilegeOwner owner, List<PostgrePrivilegeGrant> grants) {
        this.owner = owner;
        this.permissions = new ObjectPermission[grants.size()];
        int i = 0;
        while (i < grants.size()) {
            PostgrePrivilegeGrant privilege = grants.get(i);
            short permission = 1;
            if (privilege.isGrantable()) {
                permission = (short)(permission | 2);
            }
            if (privilege.isWithHierarchy()) {
                permission = (short)(permission | 4);
            }
            this.permissions[i] = new ObjectPermission(privilege.getPrivilegeType(), privilege.getGrantor(), permission);
            ++i;
        }
    }

    public DBAPrivilegeGrant[] getGrants() {
        return this.permissions;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public PostgrePrivilegeOwner getParentObject() {
        return this.owner;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    public PostgrePrivilegeOwner getOwner() {
        return this.owner;
    }

    public abstract PostgreObject getTargetObject(DBRProgressMonitor var1) throws DBException;

    public ObjectPermission[] getPermissions() {
        return this.permissions;
    }

    public PostgrePrivilegeType[] getPrivileges() {
        PostgrePrivilegeType[] ppt = new PostgrePrivilegeType[this.permissions.length];
        int i = 0;
        while (i < this.permissions.length) {
            ppt[i] = this.permissions[i].getPrivilegeType();
            ++i;
        }
        return ppt;
    }

    public short getPermission(PostgrePrivilegeType privilegeType) {
        int i = 0;
        while (i < this.permissions.length) {
            if (this.permissions[i].privilegeType == privilegeType) {
                return this.permissions[i].permissions;
            }
            ++i;
        }
        return 0;
    }

    public void setPermission(PostgrePrivilegeType privilegeType, boolean permit) {
        int i = 0;
        while (i < this.permissions.length) {
            if (this.permissions[i].privilegeType == privilegeType) {
                if (permit) {
                    ObjectPermission objectPermission = this.permissions[i];
                    objectPermission.permissions = (short)(objectPermission.permissions | 1);
                } else {
                    this.permissions[i].permissions = (short)0;
                }
            }
            ++i;
        }
    }

    public boolean hasAllPrivileges(Object object) {
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = PostgrePrivilegeType.values();
        int n = postgrePrivilegeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
            if (pt.isValid() && pt.supportsType(object.getClass()) && this.getPermission(pt) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public class ObjectPermission
    implements DBAPrivilegeGrant {
        @NotNull
        private PostgrePrivilegeType privilegeType;
        @NotNull
        private String grantor;
        private short permissions;

        public ObjectPermission(@NotNull PostgrePrivilegeType privilegeType, String grantor, short permissions) {
            this.privilegeType = privilegeType;
            this.grantor = grantor;
            this.permissions = permissions;
        }

        public DBARole getSubject(DBRProgressMonitor monitor) throws DBException {
            return PostgrePrivilege.this.owner instanceof DBARole ? (DBARole)PostgrePrivilege.this.owner : (DBARole)PostgrePrivilege.this.getTargetObject(monitor);
        }

        public DBSObject getObject(DBRProgressMonitor monitor) throws DBException {
            return PostgrePrivilege.this.owner instanceof DBARole ? PostgrePrivilege.this.getTargetObject(monitor) : PostgrePrivilege.this.owner;
        }

        public DBAPrivilege[] getPrivileges() {
            return new DBAPrivilege[]{PostgrePrivilege.this};
        }

        @NotNull
        public PostgrePrivilegeType getPrivilegeType() {
            return this.privilegeType;
        }

        public boolean isGranted() {
            return (this.permissions & 1) == 1;
        }

        @NotNull
        public String getGrantor() {
            return this.grantor;
        }

        public short getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return this.privilegeType.toString();
        }
    }
}

