/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDatabaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SelectActiveSchemaHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        if (dataSourceContainer == null) {
            log.debug((Object)"No active connection. Action is in disabled state.");
            return null;
        }
        DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContext((IWorkbenchPart)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        DatabaseListReader databaseListReader = new DatabaseListReader(dataSourceContainer.getDataSource(), executionContext);
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)databaseListReader);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Schema list", "Error reading schema list", e.getTargetException());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        DBNDatabaseNode selectedDB = null;
        for (DBNDatabaseNode node : databaseListReader.nodeList) {
            if (node.getObject() != databaseListReader.active) continue;
            selectedDB = node;
        }
        SelectDatabaseDialog dialog = new SelectDatabaseDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), dataSourceContainer, databaseListReader.currentDatabaseInstanceName, databaseListReader.nodeList, selectedDB == null ? null : Collections.singletonList(selectedDB));
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return null;
        }
        DBNDatabaseNode node = (DBNDatabaseNode)dialog.getSelectedObject();
        if (node != null && node != databaseListReader.active) {
            SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, executionContext, databaseListReader.currentDatabaseInstanceName, dialog.getCurrentInstanceName(), node.getNodeName());
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if ("true".equals(parameters.get("noCustomLabel"))) {
            return;
        }
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        final IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        String schemaName = "< N/A >";
        DBIcon schemaIcon = DBIcon.TREE_SCHEMA;
        String schemaTooltip = UINavigatorMessages.toolbar_datasource_selector_combo_database_tooltip;
        DBPDataSourceContainer dataSource = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
        if (dataSource != null && dataSource.isConnected()) {
            IEditorInput editorInput = activeEditor.getEditorInput();
            if (editorInput instanceof IDatabaseEditorInput) {
                DBSObject schemaObject;
                DBCExecutionContext executionContext;
                if (editorInput instanceof DatabaseLazyEditorInput) {
                    activeEditor.addPropertyListener(new IPropertyListener(){

                        public void propertyChanged(Object source, int propId) {
                            if (1 == propId) {
                                DataSourceToolbarUtils.updateCommandsUI();
                                activeEditor.removePropertyListener((IPropertyListener)this);
                            }
                        }
                    });
                }
                if ((executionContext = ((IDatabaseEditorInput)editorInput).getExecutionContext()) != null && (schemaObject = DBUtils.getSelectedObject((DBCExecutionContext)executionContext)) != null && DBUtils.getPublicObjectContainer((DBSObject)schemaObject) != dataSource) {
                    DBSObject schemaParent = schemaObject.getParentObject();
                    schemaName = schemaParent instanceof DBSObjectContainer && !(schemaParent instanceof DBPDataSource) ? String.valueOf(schemaObject.getName()) + "@" + schemaParent.getName() : schemaObject.getName();
                }
            } else {
                DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContext((IWorkbenchPart)activeEditor);
                DBCExecutionContextDefaults contextDefaults = null;
                if (executionContext != null) {
                    contextDefaults = executionContext.getContextDefaults();
                }
                if (contextDefaults != null) {
                    DBSCatalog defaultCatalog = contextDefaults.getDefaultCatalog();
                    DBSSchema defaultSchema = contextDefaults.getDefaultSchema();
                    if (defaultCatalog != null && (defaultSchema != null || contextDefaults.supportsSchemaChange())) {
                        schemaName = defaultSchema == null ? "?" : String.valueOf(defaultSchema.getName()) + "@" + defaultCatalog.getName();
                        schemaIcon = DBIcon.TREE_SCHEMA;
                    } else if (defaultCatalog != null) {
                        schemaName = defaultCatalog.getName();
                        schemaIcon = DBIcon.TREE_DATABASE;
                    } else if (defaultSchema != null) {
                        schemaName = defaultSchema.getName();
                        schemaIcon = DBIcon.TREE_SCHEMA;
                    }
                }
            }
        }
        element.setText(schemaName);
        element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)schemaIcon));
        element.setTooltip(schemaTooltip);
    }

    private static void changeDataBaseSelection(DBPDataSourceContainer dsContainer, final DBCExecutionContext executionContext, final @Nullable String curInstanceName, final @Nullable String newInstanceName, final @Nullable String newObjectName) {
        if (dsContainer != null && dsContainer.isConnected()) {
            final DBPDataSource dataSource = dsContainer.getDataSource();
            new AbstractJob("Change active database"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
                        if (rootContainer == null) {
                            return Status.OK_STATUS;
                        }
                        DBCExecutionContextDefaults contextDefaults = null;
                        if (executionContext != null) {
                            contextDefaults = executionContext.getContextDefaults();
                        }
                        if (contextDefaults != null && (contextDefaults.supportsSchemaChange() || contextDefaults.supportsCatalogChange())) {
                            SelectActiveSchemaHandler.changeDefaultObject(monitor, rootContainer, contextDefaults, newInstanceName, curInstanceName, newObjectName);
                        }
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static void changeDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer rootContainer, @NotNull DBCExecutionContextDefaults contextDefaults, @Nullable String newInstanceName, @Nullable String curInstanceName, @Nullable String newObjectName) throws DBException {
        boolean changeCatalog;
        DBSObject newInstance;
        DBSCatalog newCatalog = null;
        DBSSchema newSchema = null;
        if (newInstanceName != null && (newInstance = rootContainer.getChild(monitor, newInstanceName)) instanceof DBSCatalog) {
            newCatalog = (DBSCatalog)newInstance;
        }
        if (newObjectName != null) {
            DBSObject newObject = newCatalog == null ? rootContainer.getChild(monitor, newObjectName) : newCatalog.getChild(monitor, newObjectName);
            if (newObject instanceof DBSSchema) {
                newSchema = (DBSSchema)newObject;
            } else if (newObject instanceof DBSCatalog) {
                newCatalog = (DBSCatalog)newObject;
            }
        }
        boolean bl = curInstanceName != null ? !CommonUtils.equalObjects((Object)curInstanceName, (Object)newInstanceName) : (changeCatalog = newCatalog != null);
        if (newCatalog != null && newSchema != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, newSchema);
        } else if (newSchema != null) {
            contextDefaults.setDefaultSchema(monitor, newSchema);
        } else if (newCatalog != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, null);
        }
    }

    private static class DatabaseListReader
    implements DBRRunnableWithProgress {
        private final DBPDataSource dataSource;
        private final DBCExecutionContext executionContext;
        private final List<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>();
        private DBSObject active;
        private boolean enabled;
        private String currentDatabaseInstanceName;

        DatabaseListReader(DBPDataSource dataSource, DBCExecutionContext executionContext) {
            this.dataSource = dataSource;
            this.executionContext = executionContext;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
            DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.dataSource);
            if (objectContainer == null) {
                return;
            }
            DBCExecutionContextDefaults contextDefaults = null;
            if (this.executionContext != null) {
                contextDefaults = this.executionContext.getContextDefaults();
            }
            if (contextDefaults == null) {
                return;
            }
            try {
                try {
                    monitor.beginTask(UINavigatorMessages.toolbar_datasource_selector_action_read_databases, 1);
                    this.currentDatabaseInstanceName = null;
                    Class childType = objectContainer.getChildType(monitor);
                    if (childType == null || !DBSObjectContainer.class.isAssignableFrom(childType)) {
                        this.enabled = false;
                    } else {
                        Class catalogChildrenType;
                        this.enabled = true;
                        DBSCatalog defObject = null;
                        if (DBSCatalog.class.isAssignableFrom(childType)) {
                            defObject = contextDefaults.getDefaultCatalog();
                        }
                        if (defObject != null && (catalogChildrenType = defObject.getChildType(monitor)) != null && DBSSchema.class.isAssignableFrom(catalogChildrenType)) {
                            this.currentDatabaseInstanceName = defObject.getName();
                            if (contextDefaults.supportsSchemaChange()) {
                                objectContainer = defObject;
                            } else if (!contextDefaults.supportsCatalogChange()) {
                                objectContainer = null;
                            }
                            DBSSchema dBSSchema = contextDefaults.getDefaultSchema();
                            if (dBSSchema != null) {
                                defObject = dBSSchema;
                            }
                        }
                        Collection<Object> children = objectContainer == null ? (defObject == null ? Collections.emptyList() : Collections.singletonList(defObject)) : objectContainer.getChildren(monitor);
                        this.active = defObject;
                        if (children != null) {
                            for (DBSObject dBSObject : children) {
                                DBNDatabaseNode node;
                                if (DBUtils.getAdapter(DBSObjectContainer.class, (Object)dBSObject) == null || (node = navigatorModel.getNodeByObject(monitor, dBSObject, false)) == null) continue;
                                this.nodeList.add(node);
                            }
                        }
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public static class MenuContributor
    extends DataSourceMenuContributor {
        static final int DB_LIST_READ_TIMEOUT = 3000;

        @Override
        protected void fillContributionItems(List<IContributionItem> menuItems) {
            DBCExecutionContextDefaults contextDefaults;
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            final DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
            if (dataSourceContainer == null) {
                return;
            }
            final DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContext((IWorkbenchPart)workbenchWindow.getActivePage().getActiveEditor());
            final DatabaseListReader databaseListReader = new DatabaseListReader(dataSourceContainer.getDataSource(), executionContext);
            RuntimeUtils.runTask((DBRRunnableWithProgress)databaseListReader, (String)"Read database list", (long)3000L);
            DBSObject[] defObjects = null;
            if (executionContext != null && (contextDefaults = executionContext.getContextDefaults()) != null) {
                defObjects = new DBSObject[]{contextDefaults.getDefaultCatalog(), contextDefaults.getDefaultSchema()};
            }
            if (defObjects == null) {
                defObjects = new DBSObject[]{};
            }
            final DBSObject[] finalDefObjects = defObjects;
            for (final DBNDatabaseNode node : databaseListReader.nodeList) {
                menuItems.add((IContributionItem)new ActionContributionItem((IAction)new Action(node.getName(), 2){
                    private final DBSObject object;
                    {
                        super($anonymous0, $anonymous1);
                        this.object = dBNDatabaseNode.getObject();
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)dBNDatabaseNode.getNodeIcon()));
                    }

                    public boolean isChecked() {
                        return ArrayUtils.contains((Object[])finalDefObjects, (Object)this.object);
                    }

                    public void run() {
                        SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, executionContext, databaseListReader.currentDatabaseInstanceName, this.object instanceof DBSCatalog ? this.object.getName() : databaseListReader.currentDatabaseInstanceName, this.object instanceof DBSSchema ? node.getNodeName() : null);
                    }
                }));
            }
        }
    }
}

