/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CompareStructureViewerSwitchingPane
extends CompareViewerSwitchingPane {
    private CompareEditorInput fCompareEditorInput;
    private ViewerDescriptor fSelectedViewerDescriptor;
    private ToolBar toolBar;

    public CompareStructureViewerSwitchingPane(Composite parent, int style, boolean visibility, CompareEditorInput cei) {
        super(parent, style, visibility);
        this.fCompareEditorInput = cei;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.fCompareEditorInput.getCompareConfiguration();
    }

    @Override
    protected Viewer getViewer(Viewer oldViewer, Object input) {
        if (input instanceof ICompareInput) {
            if (this.fSelectedViewerDescriptor != null) {
                List<Object> list;
                ViewerDescriptor[] array = CompareUIPlugin.getDefault().findStructureViewerDescriptor(oldViewer, (ICompareInput)input, this.getCompareConfiguration());
                List<Object> list2 = list = array != null ? Arrays.asList(array) : Collections.emptyList();
                if (list.contains(this.fSelectedViewerDescriptor)) {
                    this.fCompareEditorInput.setStructureViewerDescriptor(this.fSelectedViewerDescriptor);
                    Viewer viewer = this.fCompareEditorInput.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                    return viewer;
                }
                this.fSelectedViewerDescriptor = null;
            }
            this.fCompareEditorInput.setStructureViewerDescriptor(null);
            Viewer viewer = this.fCompareEditorInput.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
            this.fCompareEditorInput.setStructureViewerDescriptor(this.fSelectedViewerDescriptor);
            return viewer;
        }
        return null;
    }

    @Override
    protected Control createTopLeft(Composite p) {
        Composite composite = new Composite(p, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        composite.setLayout((Layout)layout);
        CLabel cl = new CLabel(composite, 0);
        cl.setText(null);
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.setVisible(false);
        ToolItem toolItem = new ToolItem(this.toolBar, 8, 0);
        toolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_VIEW_MENU"));
        toolItem.setToolTipText(CompareMessages.CompareStructureViewerSwitchingPane_switchButtonTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareStructureViewerSwitchingPane.this.showMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CompareStructureViewerSwitchingPane.this.showMenu();
            }
        });
        return composite;
    }

    @Override
    protected boolean inputChanged(Object input) {
        return this.getInput() != input || this.fCompareEditorInput.getStructureViewerDescriptor() != this.fSelectedViewerDescriptor;
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        if (this.getViewer() == null || !Utilities.okToUse((Widget)this.getViewer().getControl())) {
            return;
        }
        ViewerDescriptor[] vd = null;
        if (this.getInput() instanceof ICompareInput) {
            vd = CompareUIPlugin.getDefault().findStructureViewerDescriptor(this.getViewer(), (ICompareInput)this.getInput(), this.getCompareConfiguration());
        }
        this.toolBar.setVisible(vd != null && vd.length > 1);
    }

    private void showMenu() {
        if (!(this.getInput() instanceof ICompareInput)) {
            return;
        }
        ViewerDescriptor[] vd = CompareUIPlugin.getDefault().findStructureViewerDescriptor(this.getViewer(), (ICompareInput)this.getInput(), this.getCompareConfiguration());
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        String label = CompareMessages.CompareStructureViewerSwitchingPane_defaultViewer;
        MenuItem defaultItem = new MenuItem(menu, 16);
        defaultItem.setText(label);
        defaultItem.addSelectionListener(this.createSelectionListener(null));
        defaultItem.setSelection(this.fSelectedViewerDescriptor == null);
        new MenuItem(menu, 2);
        ViewerDescriptor[] viewerDescriptorArray = vd;
        int n = vd.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                ViewerDescriptor vdi;
                block5: {
                    vdi = viewerDescriptorArray[n2];
                    label = vdi.getLabel();
                    if (label != null && !label.equals("")) break block5;
                    String l = CompareUIPlugin.getDefault().findStructureTypeNameOrType((ICompareInput)this.getInput(), vdi, this.getCompareConfiguration());
                    if (l == null) break block6;
                    label = NLS.bind((String)CompareMessages.CompareStructureViewerSwitchingPane_discoveredLabel, (Object[])new Object[]{l});
                }
                MenuItem item = new MenuItem(menu, 16);
                item.setText(label);
                item.addSelectionListener(this.createSelectionListener(vdi));
                item.setSelection(vdi == this.fSelectedViewerDescriptor);
            }
            ++n2;
        }
        Rectangle bounds = this.toolBar.getItem(0).getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(() -> menu.dispose());
            }
        });
    }

    private SelectionListener createSelectionListener(final ViewerDescriptor vd) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem mi = (MenuItem)e.widget;
                if (mi.getSelection()) {
                    Viewer oldViewer = CompareStructureViewerSwitchingPane.this.getViewer();
                    CompareStructureViewerSwitchingPane.this.fSelectedViewerDescriptor = vd;
                    CompareStructureViewerSwitchingPane.this.setInput(oldViewer.getInput());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    @Override
    public void setText(String label) {
        Control[] children;
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel cl = (CLabel)child;
                if (cl != null && !cl.isDisposed()) {
                    cl.setText(label);
                    c.layout();
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public void setImage(Image image) {
        Control[] children;
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel cl = (CLabel)child;
                if (cl != null && !cl.isDisposed()) {
                    cl.setImage(image);
                }
                return;
            }
            ++n2;
        }
    }

    public void addMouseListener(MouseListener listener) {
        Control[] children;
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel cl = (CLabel)child;
                cl.addMouseListener(listener);
            }
            ++n2;
        }
    }
}

