/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.lock;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.lock.ExasolLock;
import org.jkiss.dbeaver.ext.exasol.model.lock.ExasolLockItem;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphManager;

public class ExasolLockManager
extends LockGraphManager
implements DBAServerLockManager<ExasolLock, ExasolLockItem> {
    public static final String LOCK_QUERY = "WITH LOCKED AS (\r\nSELECT \r\nw.SESSION_ID AS w_session_id,w.login_time as w_login_time,\r\nw.user_name AS w_user_name,\r\nw.command_name AS w_command_name,\r\nw.os_user AS w_os_user,\r\nw.client AS w_client,\r\n'-' AS oname,\r\nh.session_id as h_session_id, h.CLIENT AS h_CLIENT,\r\nh.USER_NAME AS H_USER_NAME, h.status as h_status\r\nFROM SYS.EXA_DBA_SESSIONS w\r\nINNER JOIN SYS.EXA_DBA_SESSIONS h\r\nON  CASE\r\n                    WHEN w.ACTIVITY LIKE 'Waiting for %' THEN CAST(\r\n                        REPLACE(\r\n                            w.ACTIVITY,\r\n                            'Waiting for session ',\r\n                            ''\r\n                        ) AS DECIMAL(\r\n                            20,\r\n                            0\r\n                        )\r\n                    )\r\n                    ELSE NULL\r\n                END = h.SESSION_ID\r\n) \r\nSELECT * FROM locked\r\nUNION ALL\r\nSELECT\r\nw.SESSION_ID AS w_session_id,w.login_time as w_login_time,\r\nw.user_name AS w_user_name,\r\nw.command_name AS w_command_name,\r\nw.os_user AS w_os_user,\r\nw.client AS w_client,\r\n'-' AS oname,\r\nw.session_id as h_session_id, h.CLIENT AS h_CLIENT,\r\nh.USER_NAME AS H_USER_NAME, h.status as h_status\r\nFROM SYS.EXA_DBA_SESSIONS w \r\nLEFT OUTER JOIN SYS.EXA_DBA_SESSIONS h\r\nON  CASE\r\n                    WHEN w.ACTIVITY LIKE 'Waiting for %' THEN CAST(\r\n                        REPLACE(\r\n                            w.ACTIVITY,\r\n                            'Waiting for session ',\r\n                            ''\r\n                        ) AS DECIMAL(\r\n                            20,\r\n                            0\r\n                        )\r\n                    )\r\n                    ELSE NULL\r\n                END = h.SESSION_ID\r\nWHERE w.SESSION_ID IN (SELECT h_session_id FROM locked)";
    public static final String LOCK_ITEM_QUERY = "with\r\n\tEXA_SQL as (\r\n\t\tselect\r\n\t\t\tSESSION_ID,\r\n\t\t\tSTMT_ID,\r\n\t\t\tCOMMAND_CLASS,\r\n\t\t\tCOMMAND_NAME,\r\n\t\t\tSUCCESS\r\n\t\tfrom\r\n\t\t\t--EXA_DBA_AUDIT_SQL                   -- delivers more exact results (if available)\r\n\t\t\tEXA_SQL_LAST_DAY\r\n\t\twhere\r\n\t\t\tSESSION_ID in (select SESSION_ID from EXA_DBA_SESSIONS)\r\n\t),\r\n\tSESSION_RISKS as (\r\n\t\tselect\r\n\t\t\tSESSION_ID,\r\n\t\t\tHAS_LOCKS\r\n\t\tfrom\r\n\t\t\t(\r\n\t\t\t\tselect\r\n\t\t\t\t\tSESSION_ID,\r\n\t\t\t\t\tdecode(\r\n\t\t\t\t\t\tgreatest(CURRENT_ACCESS, LAST_ACCESS),\r\n\t\t\t\t\t\t0,\r\n\t\t\t\t\t\t'NONE',\r\n\t\t\t\t\t\t1,\r\n\t\t\t\t\t\t'READ LOCKS',\r\n\t\t\t\t\t\t2,\r\n\t\t\t\t\t\t'WRITE LOCKS'\r\n\t\t\t\t\t) HAS_LOCKS\r\n\t\t\t\tfrom\r\n\t\t\t\t\t(\r\n\t\t\t\t\t\tselect\r\n\t\t\t\t\t\t\tS.SESSION_ID,\r\n\t\t\t\t\t\t\tcase\r\n\t\t\t\t\t\t\t\twhen\r\n\t\t\t\t\t\t\t\t\t(S.STATUS not in ('IDLE', 'DISCONNECTED')) OR\r\n\t\t\t\t\t\t\t\t\t(\r\n\t\t\t\t\t\t\t\t\t\tS.COMMAND_NAME not in ('COMMIT', 'ROLLBACK', 'NOT SPECIFIED')\r\n\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\tthen\r\n\t\t\t\t\t\t\t\t\tcase\r\n\t\t\t\t\t\t\t\t\t\twhen\r\n\t\t\t\t\t\t\t\t\t\t\tS.COMMAND_NAME in (\r\n\t\t\t\t\t\t\t\t\t\t\t\t'SELECT', 'DESCRIBE', 'OPEN SCHEMA', 'CLOSE SCHEMA', 'FLUSH STATISTICS', 'EXECUTE SCRIPT'\r\n\t\t\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\t\t\tthen\r\n\t\t\t\t\t\t\t\t\t\t\t1\r\n\t\t\t\t\t\t\t\t\t\telse\r\n\t\t\t\t\t\t\t\t\t\t\t2\r\n\t\t\t\t\t\t\t\t\tend\r\n\t\t\t\t\t\t\t\telse\r\n\t\t\t\t\t\t\t\t\t0\r\n\t\t\t\t\t\t\tend CURRENT_ACCESS,\r\n\t\t\t\t\t\t\tzeroifnull(A.ACCESS) LAST_ACCESS\r\n\t\t\t\t\t\tfrom\r\n\t\t\t\t\t\t\t\tEXA_DBA_SESSIONS S\r\n\t\t\t\t\t\t\tleft join\r\n\t\t\t\t\t\t\t\t(\r\n\t\t\t\t\t\t\t\t\tselect\r\n\t\t\t\t\t\t\t\t\t\tSESSION_ID,\r\n\t\t\t\t\t\t\t\t\t\tmax(ACCESS) ACCESS\r\n\t\t\t\t\t\t\t\t\tFROM\r\n\t\t\t\t\t\t\t\t\t\t(\r\n\t\t\t\t\t\t\t\t\t\t\tselect\r\n\t\t\t\t\t\t\t\t\t\t\t\tSESSION_ID,\r\n\t\t\t\t\t\t\t\t\t\t\t\tcase\r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhen\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t(\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCOMMAND_NAME not in ('COMMIT', 'ROLLBACK', 'NOT SPECIFIED')\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\t\t\t\t\t\tthen\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcase\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twhen\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCOMMAND_NAME in (\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'SELECT',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'DESCRIBE',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'OPEN SCHEMA',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'CLOSE SCHEMA',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'FLUSH STATISTICS',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t'EXECUTE SCRIPT'\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tthen\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\telse\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t2\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tend\r\n\t\t\t\t\t\t\t\t\t\t\t\t\telse\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t0\r\n\t\t\t\t\t\t\t\t\t\t\t\tend ACCESS\r\n\t\t\t\t\t\t\t\t\t\t\tfrom\r\n\t\t\t\t\t\t\t\t\t\t\t\tEXA_SQL C\r\n\t\t\t\t\t\t\t\t\t\t\twhere\r\n\t\t\t\t\t\t\t\t\t\t\t\tC.COMMAND_CLASS <> 'TRANSACTION' and\r\n\t\t\t\t\t\t\t\t\t\t\t\tSUCCESS and\r\n\t\t\t\t\t\t\t\t\t\t\t\tnot exists(\r\n\t\t\t\t\t\t\t\t\t\t\t\t\tselect\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t*\r\n\t\t\t\t\t\t\t\t\t\t\t\t\tfrom\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tEXA_SQL E\r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tE.SESSION_ID = C.SESSION_ID and\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tE.STMT_ID > C.STMT_ID and\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tE.COMMAND_CLASS = 'TRANSACTION'\r\n\t\t\t\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\t\t\t)\r\n\t\t\t\t\t\t\t\t\tgroup by\r\n\t\t\t\t\t\t\t\t\t\tSESSION_ID\r\n\t\t\t\t\t\t\t\t) A\r\n\t\t\t\t\t\t\ton\r\n\t\t\t\t\t\t\t\tS.SESSION_ID = A.SESSION_ID\r\n\t\t\t\t\t)\r\n\t\t\t\twhere\r\n\t\t\t\t\tSESSION_ID <> 4\r\n\t\t\t)\r\n\t)\r\nselect\r\n\tHAS_LOCKS,\r\n\tcase\r\n\t\twhen\r\n\t\t\tDURATION > '1:00:00' and\r\n\t\t\tSTATUS = 'IDLE'\r\n\t\tthen\r\n\t\t\tdecode(\r\n\t\t\t\tHAS_LOCKS,\r\n\t\t\t\t'READ LOCKS',\r\n\t\t\t\t'CRITICAL',\r\n\t\t\t\t'WRITE LOCKS',\r\n\t\t\t\t'VERY CRITICAL',\r\n\t\t\t\tNULL\r\n\t\t\t)\r\n\tend EVALUATION,\r\n\tS.*\r\nfrom\r\n\t\tEXA_DBA_SESSIONS S\r\n\tleft join\r\n\t\tSESSION_RISKS R\r\n\ton\r\n\t\t(S.SESSION_ID = R.SESSION_ID) WHERE S.SESSION_ID = ?\r\norder by\r\n\tEVALUATION desc,\r\n\tLOGIN_TIME;\r\n";
    private final ExasolDataSource dataSource;

    public ExasolLockManager(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Map<Object, ExasolLock> getLocks(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            HashMap<Object, ExasolLock> locks = new HashMap<Object, ExasolLock>(10);
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(LOCK_QUERY);){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        ExasolLock l = new ExasolLock((ResultSet)dbResult);
                        locks.put(l.getId(), l);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            super.buildGraphs(locks);
            return locks;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public Collection<ExasolLockItem> getLockItems(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            ArrayList<ExasolLockItem> locks = new ArrayList<ExasolLockItem>();
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(LOCK_ITEM_QUERY);){
                String otype;
                switch (otype = (String)options.get("type")) {
                    case "wait": {
                        dbStat.setBigDecimal(1, new BigDecimal((BigInteger)options.get("wsid")));
                        break;
                    }
                    case "hold": {
                        dbStat.setBigDecimal(1, new BigDecimal((BigInteger)options.get("hsid")));
                        break;
                    }
                    default: {
                        return locks;
                    }
                }
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        locks.add(new ExasolLockItem((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return locks;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, ExasolLock lock, Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("KILL SESSION " + lock.getHold_sid());){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public Class<ExasolLock> getLocksType() {
        return ExasolLock.class;
    }
}

