/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ToolWizardPageLog
extends WizardPage {
    private static final Log log = Log.getLog(ToolWizardPageLog.class);
    private TextConsoleViewer consoleViewer;
    private String task;
    private OutputStreamWriter writer;
    private MessageConsole console;

    public ToolWizardPageLog(String task) {
        super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.task = task;
        this.setTitle(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.setDescription(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress_log, (Object)task));
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.console = new MessageConsole("tool-log-console", null);
        this.consoleViewer = new LogConsoleViewer(composite);
        this.console.setWaterMarks(0x300000, 0x400000);
        this.writer = new OutputStreamWriter((OutputStream)this.console.newMessageStream(), StandardCharsets.UTF_8);
        this.setControl((Control)composite);
    }

    public Writer getLogWriter() {
        return this.writer;
    }

    public void appendLog(String line) {
        this.appendLog(line, false);
    }

    public void appendLog(String line, boolean error) {
        if (this.getShell().isDisposed()) {
            return;
        }
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void clearLog() {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec(() -> {
            ToolWizardPageLog toolWizardPageLog = this;
            synchronized (toolWizardPageLog) {
                this.console.clearConsole();
            }
        });
    }

    public void startLogReader(ProcessBuilder processBuilder, InputStream stream) {
        new LogReaderJob(processBuilder, stream).start();
    }

    public void startNullReader(InputStream stream) {
        new NullReaderJob(stream).start();
    }

    private class LogConsoleViewer
    extends TextConsoleViewer
    implements IDocumentListener {
        LogConsoleViewer(Composite composite) {
            super(composite, (TextConsole)ToolWizardPageLog.this.console);
        }

        public void setDocument(IDocument document) {
            IDocument oldDocument = this.getDocument();
            super.setDocument(document);
            if (oldDocument != null) {
                oldDocument.removeDocumentListener((IDocumentListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.revealEndOfDocument();
        }
    }

    private class LogReaderJob
    extends Thread {
        private ProcessBuilder processBuilder;
        private InputStream input;

        LogReaderJob(ProcessBuilder processBuilder, InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)ToolWizardPageLog.this.task));
            this.processBuilder = processBuilder;
            this.input = stream;
        }

        @Override
        public void run() {
            AbstractToolWizard wizard = (AbstractToolWizard)ToolWizardPageLog.this.getWizard();
            String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (NativeToolUtils.isSecureString(wizard.getSettings(), (String)cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            ToolWizardPageLog.this.appendLog(cmdString.toString());
            ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_started_at, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
            try {
                try {
                    InputStream in = this.input;
                    Object object = null;
                    Object var7_9 = null;
                    try (InputStreamReader reader = new InputStreamReader(in, GeneralUtils.getDefaultConsoleEncoding());){
                        int b;
                        StringBuilder buf = new StringBuilder();
                        while ((b = ((Reader)reader).read()) != -1) {
                            buf.append((char)b);
                            if (b != 10) continue;
                            ToolWizardPageLog.this.appendLog(buf.toString());
                            buf.setLength(0);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    ToolWizardPageLog.this.appendLog(String.valueOf(e.getMessage()) + lf);
                    ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_finished, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
                }
            }
            finally {
                ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_finished, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
            }
        }
    }

    private class NullReaderJob
    extends Thread {
        private InputStream input;

        protected NullReaderJob(InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)ToolWizardPageLog.this.task));
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {}
        }
    }
}

